/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.io;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Timer;
import org.protege.editor.core.Disposable;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.io.IOListener;
import org.protege.editor.owl.model.io.IOListenerEvent;
import org.protege.editor.owl.model.io.OntologySourcesListener;
import org.semanticweb.owlapi.model.OWLOntology;

public class OntologySourcesManager
extends IOListener
implements Disposable {
    public static final String ID = OntologySourcesManager.class.getName();
    private Map<URI, Long> timestamps = new HashMap<URI, Long>();
    private Timer timer;
    private OWLModelManager mngr;
    private List<OntologySourcesListener> listeners = new ArrayList<OntologySourcesListener>();
    private ActionListener timerAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            OntologySourcesManager.this.checkSources();
        }
    };

    public OntologySourcesManager(OWLModelManager mngr) {
        this.mngr = mngr;
        mngr.addIOListener(this);
    }

    public void setTimer(int millisecs) {
        if (this.timer != null) {
            this.stopTimer();
        }
        if (millisecs > 0) {
            this.timer = new Timer(millisecs, this.timerAction);
            this.startTimer();
        } else {
            this.timer = null;
        }
    }

    public void checkSources() {
        this.stopTimer();
        Set<OWLOntology> changedOntologies = this.getChangedOntologies();
        if (!changedOntologies.isEmpty()) {
            OntologySourcesListener.OntologySourcesChangeEvent event = new OntologySourcesListener.OntologySourcesChangeEvent(this.getChangedOntologies());
            for (OntologySourcesListener l : this.listeners) {
                l.ontologySourcesChanged(event);
            }
        }
        this.startTimer();
    }

    protected Set<OWLOntology> getChangedOntologies() {
        HashSet<OWLOntology> changedOntologies = new HashSet<OWLOntology>();
        for (OWLOntology ont : this.mngr.getOntologies()) {
            URI uri = this.mngr.getOntologyPhysicalURI(ont);
            long currentTimestamp = this.getTimestamp(uri);
            if (this.timestamps.get(uri) == null || this.timestamps.get(uri) >= currentTimestamp) continue;
            changedOntologies.add(ont);
        }
        return changedOntologies;
    }

    private void update(URI uri) {
        this.stopTimer();
        long timestamp = this.getTimestamp(uri);
        if (timestamp >= 0L) {
            this.timestamps.put(uri, timestamp);
        }
        this.startTimer();
    }

    private long getTimestamp(URI uri) {
        File file;
        if ("file".equals(uri.getScheme()) && (file = new File(uri)).exists()) {
            return file.lastModified();
        }
        return -1L;
    }

    @Override
    public void beforeSave(IOListenerEvent event) {
    }

    @Override
    public void afterSave(IOListenerEvent event) {
        URI uri = event.getPhysicalURI();
        this.update(uri);
    }

    @Override
    public void beforeLoad(IOListenerEvent event) {
    }

    @Override
    public void afterLoad(IOListenerEvent event) {
        URI uri = event.getPhysicalURI();
        this.update(uri);
    }

    public void dispose() {
        this.stopTimer();
        this.timestamps.clear();
    }

    public void addListener(OntologySourcesListener l) {
        this.listeners.add(l);
    }

    public void removeListener(OntologySourcesListener l) {
        this.listeners.remove(l);
    }

    public void ignoreUpdates(Set<OWLOntology> onts) {
        this.stopTimer();
        for (OWLOntology ont : onts) {
            URI uri = this.mngr.getOntologyPhysicalURI(ont);
            long timestamp = this.getTimestamp(uri);
            if (timestamp < 0L) continue;
            this.timestamps.put(uri, timestamp);
        }
        this.startTimer();
    }

    private void startTimer() {
        if (this.timer != null) {
            this.timer.start();
        }
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }
}

