/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.io;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.protege.editor.owl.model.MissingImportHandler;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;

public class UserResolvedIRIMapper
implements OWLOntologyIRIMapper {
    private Map<IRI, URI> resolvedMissingImports = new HashMap<IRI, URI>();
    private MissingImportHandler missingImportHandler;

    public UserResolvedIRIMapper(MissingImportHandler missingImportHandler) {
        this.missingImportHandler = missingImportHandler;
    }

    public IRI getDocumentIRI(IRI ontologyIRI) {
        if (this.resolvedMissingImports.containsKey(ontologyIRI)) {
            return IRI.create((URI)this.resolvedMissingImports.get(ontologyIRI));
        }
        URI resolvedURI = this.resolveMissingImport(ontologyIRI);
        if (resolvedURI != null) {
            this.resolvedMissingImports.put(ontologyIRI, resolvedURI);
        }
        return resolvedURI != null ? IRI.create((URI)resolvedURI) : null;
    }

    private URI resolveMissingImport(IRI ontologyIRI) {
        IRI iri = this.missingImportHandler.getDocumentIRI(ontologyIRI);
        return iri != null ? iri.toURI() : null;
    }

    public void setMissingImportHandler(MissingImportHandler handler) {
        this.missingImportHandler = handler;
    }
}

