/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.library.folder;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.protege.editor.owl.model.library.folder.Algorithm;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class OntologyNameAlgorithm
implements Algorithm {
    @Override
    public Set<URI> getSuggestions(final File f) {
        try {
            final IRI iri = IRI.create((File)f);
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            manager.addIRIMapper(new OWLOntologyIRIMapper(){

                public IRI getDocumentIRI(IRI ontologyIRI) {
                    if (ontologyIRI.equals((Object)iri)) {
                        return IRI.create((File)f);
                    }
                    return IRI.create((String)"http://hopefully.not.a.valid.host.name");
                }
            });
            OWLOntologyLoaderConfiguration configuration = new OWLOntologyLoaderConfiguration();
            configuration = configuration.setLoadAnnotationAxioms(false);
            configuration = configuration.setMissingImportHandlingStrategy(MissingImportHandlingStrategy.SILENT);
            OWLOntology ontology = manager.loadOntology(iri);
            TreeSet<URI> suggestions = new TreeSet<URI>();
            OWLOntologyID id = ontology.getOntologyID();
            if (id.getOntologyIRI().isPresent()) {
                suggestions.add(((IRI)id.getOntologyIRI().get()).toURI());
                if (id.getVersionIRI().isPresent()) {
                    suggestions.add(((IRI)id.getVersionIRI().get()).toURI());
                }
            }
            return suggestions;
        }
        catch (Throwable t) {
            return Collections.emptySet();
        }
    }
}

