/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.repository.extractors;

import com.google.common.base.Optional;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFConsumer;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.xml.sax.SAXException;

public class RdfExtractorConsumer
implements RDFConsumer {
    private Set<String> ontologyProperties = new HashSet<String>();
    private IRI xmlBase;
    private Set<String> possibleOntologyNames = new HashSet<String>();
    private Map<String, String> nameToVersionMap = new HashMap<String, String>();
    private Set<String> notPossibleOntologyNames = new HashSet<String>();

    public RdfExtractorConsumer() {
        this.ontologyProperties.add(OWLRDFVocabulary.OWL_IMPORTS.getIRI().toString());
    }

    public Optional<OWLOntologyID> getOntologyID() {
        if (this.possibleOntologyNames.size() != 1) {
            return Optional.absent();
        }
        String name = this.possibleOntologyNames.iterator().next();
        String version = this.nameToVersionMap.get(name);
        if (version == null) {
            return Optional.of((Object)new OWLOntologyID(Optional.of((Object)IRI.create((String)name)), Optional.absent()));
        }
        return Optional.of((Object)new OWLOntologyID(Optional.of((Object)IRI.create((String)name)), Optional.of((Object)IRI.create((String)version))));
    }

    public void logicalURI(IRI logicalURI) {
        this.xmlBase = logicalURI;
    }

    public void statementWithResourceValue(String subject, String predicate, String object) {
        if (this.ontologyProperties.contains(predicate)) {
            this.notPossibleOntologyNames.add(object);
            this.possibleOntologyNames.remove(object);
        } else if (predicate.equals(OWLRDFVocabulary.RDF_TYPE.toString()) && object.equals("http://www.w3.org/2002/07/owl#OntologyProperty")) {
            this.ontologyProperties.add(subject.toString());
        } else if (predicate.equals(OWLRDFVocabulary.RDF_TYPE.toString()) && object.equals(OWLRDFVocabulary.OWL_ONTOLOGY.toString()) && !this.notPossibleOntologyNames.contains(subject)) {
            this.possibleOntologyNames.add(subject);
        } else if (predicate.equals(OWLRDFVocabulary.OWL_VERSION_IRI.toString())) {
            this.nameToVersionMap.put(subject, object);
        }
    }

    public void statementWithResourceValue(IRI subject, IRI predicate, IRI object) {
    }

    public void addModelAttribte(String key, String value) throws SAXException {
    }

    public void endModel() {
    }

    public void includeModel(String logicalURI, String physicalURI) {
    }

    public void startModel(String physicalURI) throws SAXException {
    }

    public void startModel(IRI iri) {
    }

    public void statementWithLiteralValue(IRI iri, IRI iri1, String s, String s1, IRI iri2) {
    }

    public void statementWithLiteralValue(String subject, String predicate, String object, String language, String datatype) {
    }

    public IRI remapIRI(IRI iri) {
        return iri;
    }

    public String remapOnlyIfRemapped(String s) {
        return s;
    }

    public void addPrefix(String s, String s1) {
    }
}

