/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.selection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.protege.editor.core.Disposable;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.inference.NoOpReasoner;
import org.protege.editor.owl.model.selection.OWLSelectionModel;
import org.protege.editor.owl.model.selection.OWLSelectionModelListener;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLClassAssertionSelectionModel
implements Disposable {
    public static Logger logger = LoggerFactory.getLogger(OWLClassAssertionSelectionModel.class);
    private OWLEditorKit editorKit;
    private OWLSelectionModel mainSelectionModel;
    private OWLClass owlClass;
    private OWLClass inferredOwlClass;
    private OWLIndividual individual;
    private boolean inferredOwlClassNeedsRecalculation = true;
    private List<OWLSelectionModelListener> listeners = new ArrayList<OWLSelectionModelListener>();
    private OWLSelectionModelListener mainSelectionListener = new OWLSelectionModelListener(){

        @Override
        public void selectionChanged() throws Exception {
            OWLClassAssertionSelectionModel.this.mainSelectionChanged();
        }
    };

    public static OWLClassAssertionSelectionModel get(OWLEditorKit editorKit) {
        OWLClassAssertionSelectionModel selectionModel = (OWLClassAssertionSelectionModel)editorKit.get(OWLClassAssertionSelectionModel.class);
        if (selectionModel == null) {
            selectionModel = new OWLClassAssertionSelectionModel(editorKit);
            selectionModel.initialise();
            editorKit.put(OWLClassAssertionSelectionModel.class, selectionModel);
        }
        return selectionModel;
    }

    private OWLClassAssertionSelectionModel(OWLEditorKit editorKit) {
        this.editorKit = editorKit;
    }

    private void initialise() {
        this.mainSelectionModel = this.editorKit.getOWLWorkspace().getOWLSelectionModel();
    }

    private void mainSelectionChanged() {
        OWLEntity e = this.mainSelectionModel.getSelectedEntity();
        if (e instanceof OWLClass) {
            this.owlClass = (OWLClass)e;
            this.inferredOwlClass = (OWLClass)e;
            this.individual = null;
            this.fireSelectionChanged();
        } else if (e instanceof OWLIndividual) {
            this.individual = this.individual;
            this.inferredOwlClassNeedsRecalculation = true;
            OWLModelManager modelManager = this.editorKit.getOWLModelManager();
            Collection types = EntitySearcher.getTypes((OWLIndividual)this.individual, modelManager.getActiveOntologies());
            if (!types.contains(this.owlClass)) {
                this.owlClass = null;
                for (OWLClassExpression type : types) {
                    if (type.isAnonymous()) continue;
                    this.owlClass = type.asOWLClass();
                }
            }
            this.fireSelectionChanged();
        }
    }

    public OWLClass getOwlClass() {
        return this.owlClass;
    }

    public OWLClass getInferredOwlClass() {
        OWLReasoner reasoner = this.editorKit.getOWLModelManager().getOWLReasonerManager().getCurrentReasoner();
        if (this.individual == null || this.individual.isAnonymous() || reasoner instanceof NoOpReasoner) {
            return this.owlClass;
        }
        if (this.inferredOwlClassNeedsRecalculation) {
            this.recalculateInferredOwlClass(reasoner);
            this.inferredOwlClassNeedsRecalculation = false;
        }
        return this.inferredOwlClass;
    }

    private void recalculateInferredOwlClass(OWLReasoner reasoner) {
        block1: {
            if (this.inferredOwlClass != null && reasoner.getInstances((OWLClassExpression)this.owlClass, true).containsEntity((OWLObject)this.individual.asOWLNamedIndividual())) break block1;
            this.inferredOwlClass = null;
            Iterator iterator = reasoner.getTypes(this.individual.asOWLNamedIndividual(), true).getFlattened().iterator();
            if (iterator.hasNext()) {
                OWLClass cls;
                this.inferredOwlClass = cls = (OWLClass)iterator.next();
            }
        }
    }

    public OWLIndividual getIndividual() {
        return this.individual;
    }

    public void addListener(OWLSelectionModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(OWLSelectionModelListener listener) {
        this.listeners.remove(listener);
    }

    private void fireSelectionChanged() {
        for (OWLSelectionModelListener listener : this.listeners) {
            try {
                listener.selectionChanged();
            }
            catch (Exception e) {
                logger.warn("BAD LISTENER: (" + listener.getClass().getSimpleName() + ") ");
            }
        }
    }

    public void dispose() throws Exception {
        this.mainSelectionModel.removeListener(this.mainSelectionListener);
    }
}

