/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.user;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.protege.editor.owl.model.user.UserNamePreferencesManager;
import org.protege.editor.owl.model.user.UserNameProvider;

public class DefaultUserNameProvider
implements UserNameProvider {
    private final UserNamePreferencesManager preferencesManager;

    public DefaultUserNameProvider(UserNamePreferencesManager preferencesManager) {
        this.preferencesManager = (UserNamePreferencesManager)Preconditions.checkNotNull((Object)preferencesManager);
    }

    @Override
    public Optional<String> getUserName() {
        Optional<String> userName = this.preferencesManager.getUserName();
        if (userName.isPresent()) {
            return userName;
        }
        String loggedInUserName = System.getProperty("user.name");
        if (loggedInUserName == null) {
            return Optional.empty();
        }
        return Optional.of(loggedInUserName);
    }
}

