/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.user;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.owl.model.user.Orcid;
import org.protege.editor.owl.model.user.OrcidProvider;

public class OrcidPreferencesManager
implements OrcidProvider {
    private static final String PREFERENCES_KEY = "user.orcid";
    private final Preferences preferences;

    public OrcidPreferencesManager(Preferences preferences) {
        this.preferences = (Preferences)Preconditions.checkNotNull((Object)preferences);
    }

    @Override
    public Optional<Orcid> getOrcid() {
        String orcid = this.preferences.getString(PREFERENCES_KEY, null);
        if (orcid == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(new Orcid(orcid));
    }

    public void setOrcid(Orcid orcid) {
        this.preferences.putString(PREFERENCES_KEY, orcid.getValue());
    }

    public void clearOrcid() {
        this.preferences.putString(PREFERENCES_KEY, null);
    }
}

