/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.ui.util.AugmentedJTextField;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.entity.CustomOWLEntityFactory;
import org.protege.editor.owl.model.entity.OWLEntityCreationException;
import org.protege.editor.owl.model.entity.OWLEntityCreationSet;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.clsdescriptioneditor.ExpressionEditorPreferences;
import org.protege.editor.owl.ui.preferences.NewEntitiesPreferencesPanel;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.vocab.Namespaces;

public class OWLEntityCreationPanel<T extends OWLEntity>
extends JPanel
implements VerifiedInputEditor {
    private static final long serialVersionUID = -2790553738912229896L;
    public static final int FIELD_WIDTH = 40;
    private OWLEditorKit owlEditorKit;
    private JTextField userSuppliedNameField;
    private Class<T> type;
    private List<InputVerificationStatusChangedListener> listeners = new ArrayList<InputVerificationStatusChangedListener>();
    private boolean currentlyValid = true;
    private Timer timer = new Timer(ExpressionEditorPreferences.getInstance().getCheckDelay(), new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            OWLEntityCreationPanel.this.timer.stop();
        }
    });
    private final AugmentedJTextField entityIRIField = new AugmentedJTextField(40, "IRI (auto-generated)");
    private final JTextArea messageArea = new JTextArea(1, 40);

    public OWLEntityCreationPanel(OWLEditorKit owlEditorKit, String message, Class<T> type) {
        this.owlEditorKit = owlEditorKit;
        this.type = type;
        this.createUI(message);
    }

    @Override
    public void setEnabled(boolean b) {
        this.userSuppliedNameField.setEnabled(b);
        super.setEnabled(b);
    }

    @Override
    public void setName(String name) {
        this.userSuppliedNameField.setText(name);
    }

    private void createUI(String message) {
        this.setLayout(new BorderLayout());
        JPanel holder = new JPanel(new GridBagLayout());
        this.add(holder);
        Insets insets = new Insets(0, 0, 2, 2);
        int rowIndex = 0;
        holder.add((Component)new JLabel("Name:"), new GridBagConstraints(0, rowIndex, 1, 1, 0.0, 0.0, 768, 0, insets, 0, 0));
        this.userSuppliedNameField = new AugmentedJTextField(30, "Short name or full IRI or Prefix-Name");
        this.userSuppliedNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                OWLEntityCreationPanel.this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                OWLEntityCreationPanel.this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        holder.add((Component)this.userSuppliedNameField, new GridBagConstraints(1, rowIndex, 1, 1, 100.0, 0.0, 512, 2, insets, 0, 0));
        holder.add((Component)new JSeparator(), new GridBagConstraints(0, ++rowIndex, 2, 1, 100.0, 0.0, 10, 2, new Insets(10, 2, 10, 2), 0, 0));
        holder.add((Component)new JLabel("IRI:"), new GridBagConstraints(0, ++rowIndex, 1, 1, 0.0, 0.0, 768, 0, insets, 0, 0));
        this.entityIRIField.setForeground(Color.GRAY);
        this.entityIRIField.setEditable(false);
        holder.add((Component)this.entityIRIField, new GridBagConstraints(1, rowIndex, 1, 1, 100.0, 0.0, 768, 2, insets, 0, 0));
        holder.add((Component)new JButton(new AbstractAction("New entity options..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                OWLEntityCreationPanel.this.showEntityCreationPreferences();
            }
        }), new GridBagConstraints(1, ++rowIndex, 1, 1, 0.0, 0.0, 13, 0, new Insets(7, 0, 0, 0), 0, 0));
        holder.add((Component)new JSeparator(), new GridBagConstraints(0, ++rowIndex, 2, 1, 100.0, 0.0, 10, 2, new Insets(10, 2, 5, 2), 0, 0));
        ++rowIndex;
        this.messageArea.setBackground(null);
        this.messageArea.setBorder(null);
        this.messageArea.setEditable(false);
        this.messageArea.setWrapStyleWord(true);
        this.messageArea.setLineWrap(true);
        this.messageArea.setFont(this.messageArea.getFont().deriveFont(12.0f));
        this.messageArea.setForeground(Color.RED);
        holder.add((Component)this.messageArea, new GridBagConstraints(0, rowIndex, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.update();
    }

    private void showEntityCreationPreferences() {
        try {
            NewEntitiesPreferencesPanel panel = new NewEntitiesPreferencesPanel();
            panel.setup("Entity creation preferences", (EditorKit)this.owlEditorKit);
            panel.initialise();
            int ret = JOptionPane.showConfirmDialog(this, panel, "Entity Creation Preferences", 2, -1);
            if (ret == 0) {
                panel.applyChanges();
                this.update();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isEntityIRI() {
        String entityName = this.getEntityName();
        for (Namespaces ns : Namespaces.values()) {
            if (!entityName.startsWith(ns.name().toLowerCase() + ":")) continue;
            return true;
        }
        OWLModelManager owlModelManager = this.owlEditorKit.getOWLModelManager();
        OWLOntologyManager owlOntologyManager = owlModelManager.getOWLOntologyManager();
        for (OWLOntology ont : owlModelManager.getActiveOntologies()) {
            OWLDocumentFormat format = owlOntologyManager.getOntologyFormat(ont);
            if (format == null || !format.isPrefixOWLOntologyFormat()) continue;
            PrefixDocumentFormat prefixFormat = format.asPrefixOWLOntologyFormat();
            for (String prefix : prefixFormat.getPrefixNames()) {
                if (!entityName.startsWith(prefix)) continue;
                return true;
            }
        }
        try {
            URI uri = new URI(entityName);
            return uri.isAbsolute() && uri.getPath() != null;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public String getEntityName() {
        return this.userSuppliedNameField.getText().trim();
    }

    public OWLEntityCreationSet<T> getOWLEntityCreationSet() throws RuntimeException {
        return this.getOWLEntityCreationSet(EntityCreationMode.CREATE);
    }

    public OWLEntityCreationSet<T> getOWLEntityCreationSet(EntityCreationMode preview) throws RuntimeException {
        try {
            if (this.isEntityIRI()) {
                IRI iri = this.getRawIRI();
                OWLOntology ontology = this.owlEditorKit.getModelManager().getActiveOntology();
                OWLDataFactory factory = this.owlEditorKit.getModelManager().getOWLDataFactory();
                T owlEntity = CustomOWLEntityFactory.getOWLEntity(factory, this.type, iri);
                AddAxiom addDecl = new AddAxiom(ontology, (OWLAxiom)factory.getOWLDeclarationAxiom(owlEntity));
                return new OWLEntityCreationSet<T>(owlEntity, Collections.singletonList(addDecl));
            }
            switch (preview) {
                case CREATE: {
                    return this.owlEditorKit.getModelManager().getOWLEntityFactory().createOWLEntity(this.type, this.getEntityName(), this.getBaseIRI());
                }
                case PREVIEW: {
                    return this.owlEditorKit.getModelManager().getOWLEntityFactory().preview(this.type, this.getEntityName(), this.getBaseIRI());
                }
            }
            throw new IllegalStateException("Programmer error - report this (with stack trace) to the Protege 4 mailing list");
        }
        catch (OWLEntityCreationException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.add(listener);
        listener.verifiedStatusChanged(this.currentlyValid);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.remove(listener);
    }

    public static <T extends OWLEntity> OWLEntityCreationSet<T> showDialog(OWLEditorKit owlEditorKit, String message, Class<T> type) {
        OWLEntityCreationPanel<T> panel = new OWLEntityCreationPanel<T>(owlEditorKit, message, type);
        int ret = new UIHelper(owlEditorKit).showValidatingDialog("Create a new " + type.getSimpleName(), panel, panel.userSuppliedNameField);
        if (ret == 0) {
            return panel.getOWLEntityCreationSet();
        }
        return null;
    }

    public IRI getBaseIRI() {
        return null;
    }

    private void update() {
        try {
            this.entityIRIField.setText("");
            this.messageArea.setText("");
            if (this.userSuppliedNameField.getText().trim().isEmpty()) {
                this.setValid(false);
                return;
            }
            OWLEntityCreationSet<T> creationSet = this.getOWLEntityCreationSet(EntityCreationMode.PREVIEW);
            if (creationSet == null) {
                this.setValid(false);
                return;
            }
            T owlEntity = creationSet.getOWLEntity();
            String iriString = owlEntity.getIRI().toString();
            this.entityIRIField.setText(iriString);
            this.setValid(true);
        }
        catch (RuntimeException e) {
            this.setValid(false);
            Throwable cause = e.getCause();
            if (cause != null) {
                if (cause instanceof OWLOntologyCreationException) {
                    this.messageArea.setText("Entity already exists");
                } else {
                    this.messageArea.setText(cause.getMessage());
                }
            }
            this.messageArea.setText(e.getMessage());
        }
    }

    private void setValid(boolean valid) {
        this.currentlyValid = valid;
        this.fireVerificationStatusChanged();
    }

    private void fireVerificationStatusChanged() {
        for (InputVerificationStatusChangedListener l : this.listeners) {
            l.verifiedStatusChanged(this.currentlyValid);
        }
    }

    private IRI getRawIRI() {
        String prefixName;
        PrefixDocumentFormat prefixes;
        String prefix;
        String text = this.getEntityName();
        OWLOntology activeOntology = this.owlEditorKit.getModelManager().getActiveOntology();
        OWLOntologyManager manager = this.owlEditorKit.getModelManager().getOWLOntologyManager();
        OWLDocumentFormat format = manager.getOntologyFormat(activeOntology);
        for (Namespaces ns : Namespaces.values()) {
            if (!text.startsWith(ns.name().toLowerCase() + ":")) continue;
            return IRI.create((String)(ns.toString() + text.substring(ns.name().length() + 1)));
        }
        int colonIndex = text.indexOf(58);
        if (colonIndex >= 0 && format != null && format.isPrefixOWLOntologyFormat() && (prefix = (prefixes = format.asPrefixOWLOntologyFormat()).getPrefix(prefixName = text.substring(0, colonIndex + 1))) != null) {
            return IRI.create((String)(prefix + text.substring(colonIndex + 1)));
        }
        return IRI.create((String)text);
    }

    public JComponent getFocusComponent() {
        return this.userSuppliedNameField;
    }

    public static enum EntityCreationMode {
        PREVIEW,
        CREATE;

    }
}

