/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProvider;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProviderListener;
import org.protege.editor.owl.model.selection.OWLSelectionModelListener;
import org.protege.editor.owl.ui.OWLIndividualListComponent;
import org.protege.editor.owl.ui.tree.OWLModelManagerTree;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;

public class OWLEntitySelectorPanel
extends JPanel {
    private static final long serialVersionUID = 1535094473176412285L;
    private OWLEditorKit owlEditorKit;
    private JTabbedPane tabbedPane;
    private OWLModelManagerTree<OWLClass> classTree;
    private OWLModelManagerTree<OWLObjectProperty> objectPropertyTree;
    private OWLModelManagerTree<OWLDataProperty> dataPropertyTree;
    private OWLIndividualListComponent individualsList;
    private Map<JComponent, JComponent> tabbedPaneComponentMap;
    private AssertedInferredHierarchyProvider<OWLClass> classHierarchyProvider;
    private JSplitPane classHierarchySplitPane;

    public OWLEntitySelectorPanel(OWLEditorKit owlEditorKit) {
        this.owlEditorKit = owlEditorKit;
        this.tabbedPaneComponentMap = new IdentityHashMap<JComponent, JComponent>();
        this.createUI();
        owlEditorKit.getWorkspace().getOWLSelectionModel().addListener(new OWLSelectionModelListener(){

            @Override
            public void selectionChanged() throws Exception {
                OWLEntitySelectorPanel.this.updateSelectionFromModel();
            }
        });
        owlEditorKit.getModelManager().addListener(new OWLModelManagerListener(){

            @Override
            public void handleChange(OWLModelManagerChangeEvent event) {
                if (event.isType(EventType.REASONER_CHANGED)) {
                    OWLEntitySelectorPanel.this.handleReasonerChanged();
                }
            }
        });
    }

    private void createUI() {
        this.setLayout(new BorderLayout(7, 7));
        this.classHierarchySplitPane = new JSplitPane(0);
        this.classHierarchySplitPane.setBorder(null);
        this.classHierarchySplitPane.setResizeWeight(0.8);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setFont(this.tabbedPane.getFont().deriveFont(0, 11.0f));
        this.add((Component)this.classHierarchySplitPane, "Center");
        this.classHierarchySplitPane.setBottomComponent(this.tabbedPane);
        this.createClassTree();
        this.createObjectPropertyTree();
        this.createDataPropertyTree();
        this.createIndividualsList();
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                OWLEntitySelectorPanel.this.handleTabSelectionChange();
            }
        });
    }

    private void createButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridLayout(1, 1, 7, 7));
        JButton but = new JButton("Add class");
        but.setFont(but.getFont().deriveFont(0, 11.0f));
        buttonPanel.add(but);
        but.setFont(but.getFont().deriveFont(0, 11.0f));
        but = new JButton("Add property");
        buttonPanel.add(but);
        but.setFont(but.getFont().deriveFont(0, 11.0f));
        but = new JButton("Add individual");
        buttonPanel.add(but);
        but.setFont(but.getFont().deriveFont(0, 11.0f));
        this.add((Component)buttonPanel, "North");
    }

    private void setModelSelection(OWLEntity entity) {
        this.owlEditorKit.getWorkspace().getOWLSelectionModel().setSelectedEntity(entity);
    }

    private void createClassTree() {
        this.classHierarchyProvider = new AssertedInferredHierarchyProvider<OWLClass>(this.owlEditorKit.getModelManager().getOWLHierarchyManager().getOWLClassHierarchyProvider(), this.owlEditorKit.getModelManager().getOWLHierarchyManager().getInferredOWLClassHierarchyProvider());
        this.classTree = new OWLModelManagerTree<OWLClass>(this.owlEditorKit, this.classHierarchyProvider);
        this.classTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                OWLEntitySelectorPanel.this.setModelSelection((OWLEntity)OWLEntitySelectorPanel.this.classTree.getSelectedOWLObject());
            }
        });
        this.classHierarchySplitPane.setTopComponent(new JScrollPane(this.classTree));
    }

    private void createObjectPropertyTree() {
        this.objectPropertyTree = new OWLModelManagerTree<OWLObjectProperty>(this.owlEditorKit, this.owlEditorKit.getModelManager().getOWLHierarchyManager().getOWLObjectPropertyHierarchyProvider());
        this.objectPropertyTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                OWLEntitySelectorPanel.this.setModelSelection((OWLEntity)OWLEntitySelectorPanel.this.objectPropertyTree.getSelectedOWLObject());
            }
        });
        this.tabbedPane.add("Object properties", this.createHierarchyHolder(this.objectPropertyTree));
    }

    private void createDataPropertyTree() {
        this.dataPropertyTree = new OWLModelManagerTree<OWLDataProperty>(this.owlEditorKit, this.owlEditorKit.getModelManager().getOWLHierarchyManager().getOWLDataPropertyHierarchyProvider());
        this.dataPropertyTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                OWLEntitySelectorPanel.this.setModelSelection((OWLEntity)OWLEntitySelectorPanel.this.dataPropertyTree.getSelectedOWLObject());
            }
        });
        this.tabbedPane.add("Data properties", this.createHierarchyHolder(this.dataPropertyTree));
    }

    private void createIndividualsList() {
        this.individualsList = new OWLIndividualListComponent(this.owlEditorKit);
        this.individualsList.getList().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    OWLEntitySelectorPanel.this.setModelSelection((OWLEntity)OWLEntitySelectorPanel.this.individualsList.getSelectedIndividual());
                }
            }
        });
        this.tabbedPane.add("Individuals", this.createHierarchyHolder(this.individualsList));
    }

    private JComponent createHierarchyHolder(JComponent hierarchy) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        panel.add(new JScrollPane(hierarchy));
        this.tabbedPaneComponentMap.put(hierarchy, panel);
        return panel;
    }

    private void updateSelectionFromModel() {
        OWLEntity entity = this.owlEditorKit.getWorkspace().getOWLSelectionModel().getSelectedEntity();
        this.setSelection(entity);
    }

    private void handleTabSelectionChange() {
        Object selComp = null;
        for (JComponent key : this.tabbedPaneComponentMap.keySet()) {
            if (!this.tabbedPaneComponentMap.get(key).equals(this.tabbedPane.getSelectedComponent())) continue;
            selComp = key;
            break;
        }
        if (selComp == null) {
            return;
        }
        if (selComp.equals(this.classTree)) {
            this.setModelSelection((OWLEntity)this.classTree.getSelectedOWLObject());
        } else if (selComp.equals(this.objectPropertyTree)) {
            this.setModelSelection((OWLEntity)this.objectPropertyTree.getSelectedOWLObject());
        } else if (selComp.equals(this.dataPropertyTree)) {
            this.setModelSelection((OWLEntity)this.dataPropertyTree.getSelectedOWLObject());
        } else if (selComp.equals(this.individualsList)) {
            this.setModelSelection((OWLEntity)this.individualsList.getSelectedIndividual());
        }
    }

    public Object getSelection() {
        return null;
    }

    public void setSelection(Object sel) {
        if (sel instanceof OWLClass) {
            if (this.classTree.getSelectedOWLObject() != null && !((OWLClass)this.classTree.getSelectedOWLObject()).equals(sel)) {
                this.classTree.setSelectedOWLObject((OWLClass)sel);
                this.tabbedPane.setSelectedComponent(this.tabbedPaneComponentMap.get(this.classTree));
            }
        } else if (sel instanceof OWLObjectProperty) {
            this.objectPropertyTree.setSelectedOWLObject((OWLObjectProperty)sel);
            this.tabbedPane.setSelectedComponent(this.tabbedPaneComponentMap.get(this.objectPropertyTree));
        } else if (sel instanceof OWLDataProperty) {
            this.dataPropertyTree.setSelectedOWLObject((OWLDataProperty)sel);
            this.tabbedPane.setSelectedComponent(this.tabbedPaneComponentMap.get(this.dataPropertyTree));
        } else if (sel instanceof OWLIndividual) {
            this.individualsList.getList().setSelectedValue(sel, true);
            this.tabbedPane.setSelectedComponent(this.tabbedPaneComponentMap.get(this.individualsList));
        }
    }

    private void handleReasonerChanged() {
    }

    private class AssertedInferredHierarchyProvider<N extends OWLObject>
    implements OWLObjectHierarchyProvider<N> {
        private OWLObjectHierarchyProvider<N> asserted;
        private OWLObjectHierarchyProvider<N> inferred;
        private OWLObjectHierarchyProvider<N> current;
        private ArrayList<OWLObjectHierarchyProviderListener<N>> listeners;

        public AssertedInferredHierarchyProvider(OWLObjectHierarchyProvider<N> asserted, OWLObjectHierarchyProvider<N> inferred) {
            this.asserted = asserted;
            this.inferred = inferred;
            this.current = asserted;
            this.listeners = new ArrayList();
        }

        public void swapToInferred() {
            if (this.current != this.inferred) {
                this.current = this.inferred;
                this.swapListeners(this.asserted, this.inferred);
                this.fireChange();
            }
        }

        public void swapToAsserted() {
            if (this.current != this.asserted) {
                this.current = this.asserted;
                this.swapListeners(this.inferred, this.asserted);
                this.fireChange();
            }
        }

        @Override
        public void setFilter(Predicate<N> filter) {
            this.current.setFilter(filter);
        }

        @Override
        public void clearFilter() {
            this.current.clearFilter();
        }

        @Override
        public Predicate<N> getFilter() {
            return this.current.getFilter();
        }

        private void swapListeners(OWLObjectHierarchyProvider<N> from, OWLObjectHierarchyProvider<N> to) {
            for (OWLObjectHierarchyProviderListener<N> listener : this.listeners) {
                from.removeListener(listener);
                to.addListener(listener);
            }
        }

        @Override
        public void addListener(OWLObjectHierarchyProviderListener<N> listener) {
            this.current.addListener(listener);
            this.listeners.add(listener);
        }

        @Override
        public boolean containsReference(N object) {
            return this.current.containsReference(object);
        }

        @Override
        public void dispose() {
        }

        @Override
        public Set<N> getAncestors(N object) {
            return this.current.getAncestors(object);
        }

        @Override
        public Set<N> getChildren(N object) {
            return this.current.getChildren(object);
        }

        @Override
        public Set<N> getDescendants(N object) {
            return this.current.getDescendants(object);
        }

        @Override
        public Set<N> getEquivalents(N object) {
            return this.current.getEquivalents(object);
        }

        @Override
        public Set<N> getParents(N object) {
            return this.current.getParents(object);
        }

        @Override
        public Set getPathsToRoot(N object) {
            return this.current.getPathsToRoot(object);
        }

        @Override
        public Set<N> getRoots() {
            return this.current.getRoots();
        }

        @Override
        public void removeListener(OWLObjectHierarchyProviderListener<N> listener) {
            this.current.removeListener(listener);
            this.listeners.remove(listener);
        }

        @Override
        public void setOntologies(Set<OWLOntology> set) {
            this.asserted.setOntologies(set);
            this.inferred.setOntologies(set);
        }

        private void fireChange() {
            for (OWLObjectHierarchyProviderListener<N> listener : this.listeners) {
                listener.hierarchyChanged();
            }
        }
    }
}

