/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.OWLWorkspace;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.selection.OWLSelectionModelListener;
import org.protege.editor.owl.ui.OWLOntologyDisplayPanel;
import org.protege.editor.owl.ui.frame.OWLEntityFrame;
import org.protege.editor.owl.ui.framelist.OWLFrameList;
import org.protege.editor.owl.ui.usage.UsagePanel;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.OWLObjectVisitorAdapter;

public class SelectedObjectPanel
extends JPanel {
    private static final long serialVersionUID = -1836316447338285493L;
    private OWLEditorKit owlEditorKit;
    private OWLEntityFrame entityFrame;
    private OWLFrameList frameList;
    private CardLayout layout;
    private JPanel cardPanel;
    private OWLOntologyDisplayPanel ontologyPanel;
    private JLabel objectDisplayLabel;
    private JCheckBox showUsageCheckBox;
    private JSplitPane usageSplitPane;
    private UsagePanel usagePanel;

    public SelectedObjectPanel(OWLEditorKit owlEditorKit) {
        this.owlEditorKit = owlEditorKit;
        this.setLayout(new BorderLayout(3, 3));
        this.layout = new CardLayout();
        this.cardPanel = new JPanel(this.layout);
        this.add(this.cardPanel);
        this.objectDisplayLabel = new JLabel();
        JPanel headerPanel = new JPanel(new BorderLayout(7, 7));
        headerPanel.add((Component)this.objectDisplayLabel, "West");
        this.add((Component)headerPanel, "North");
        this.showUsageCheckBox = new JCheckBox(new AbstractAction("Show usage"){
            private static final long serialVersionUID = -8105770102874054033L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectedObjectPanel.this.showUsagePanel(SelectedObjectPanel.this.showUsageCheckBox.isSelected());
            }
        });
        headerPanel.add((Component)this.showUsageCheckBox, "East");
        this.entityFrame = new OWLEntityFrame(this.getOWLEditorKit());
        this.frameList = new OWLFrameList(this.getOWLEditorKit(), this.entityFrame);
        this.cardPanel.add("ENTITIES", new JScrollPane((Component)((Object)this.frameList)));
        owlEditorKit.getWorkspace().getOWLSelectionModel().addListener(new OWLSelectionModelListener(){

            @Override
            public void selectionChanged() throws Exception {
                OWLObject selObj = SelectedObjectPanel.this.getOWLWorkspace().getOWLSelectionModel().getSelectedObject();
                SelectedObjectPanel.this.frameList.setRootObject(selObj);
                if (selObj instanceof OWLEntity) {
                    SelectedObjectPanel.this.layout.show(SelectedObjectPanel.this.cardPanel, "ENTITIES");
                } else if (selObj instanceof OWLOntology) {
                    SelectedObjectPanel.this.ontologyPanel.setOntology((OWLOntology)selObj);
                    SelectedObjectPanel.this.layout.show(SelectedObjectPanel.this.cardPanel, "ONTOLOGY");
                }
                SelectedObjectPanel.this.updateLabel(selObj);
            }
        });
        this.frameList.setRootObject(null);
        this.getOWLModelManager().addListener(new OWLModelManagerListener(){

            @Override
            public void handleChange(OWLModelManagerChangeEvent event) {
                if (event.isType(EventType.ACTIVE_ONTOLOGY_CHANGED)) {
                    OWLOntology ontology = SelectedObjectPanel.this.getOWLModelManager().getActiveOntology();
                    SelectedObjectPanel.this.ontologyPanel.setOntology(ontology);
                    SelectedObjectPanel.this.layout.show(SelectedObjectPanel.this.cardPanel, "ONTOLOGY");
                    SelectedObjectPanel.this.updateLabel((OWLObject)ontology);
                }
            }
        });
        this.ontologyPanel = new OWLOntologyDisplayPanel(owlEditorKit);
        this.cardPanel.add("ONTOLOGY", this.ontologyPanel);
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.usagePanel = new UsagePanel(owlEditorKit);
        this.usageSplitPane = new JSplitPane(1);
        this.usageSplitPane.setResizeWeight(0.9);
        this.usageSplitPane.setRightComponent(this.usagePanel);
        this.usageSplitPane.setBorder(null);
    }

    private void showUsagePanel(boolean b) {
        if (b) {
            this.remove(this.cardPanel);
            this.usageSplitPane.setLeftComponent(this.cardPanel);
            this.add(this.usageSplitPane);
            this.revalidate();
        } else {
            this.remove(this.usageSplitPane);
            this.add(this.cardPanel);
            this.revalidate();
        }
    }

    private void updateLabel(final OWLObject object) {
        object.accept((OWLObjectVisitor)new OWLObjectVisitorAdapter(){

            public void visit(OWLClass owlClass) {
                SelectedObjectPanel.this.objectDisplayLabel.setText("<html><body><b>Class: </b>" + SelectedObjectPanel.this.owlEditorKit.getModelManager().getRendering(object) + "</body></html>");
            }

            public void visit(OWLDataProperty owlDataProperty) {
                SelectedObjectPanel.this.objectDisplayLabel.setText("<html><body><b>Data property: </b>" + SelectedObjectPanel.this.owlEditorKit.getModelManager().getRendering(object) + "</body></html>");
            }

            public void visit(OWLIndividual owlIndividual) {
                SelectedObjectPanel.this.objectDisplayLabel.setText("<html><body><b>Individual: </b>" + SelectedObjectPanel.this.owlEditorKit.getModelManager().getRendering(object) + "</body></html>");
            }

            public void visit(OWLObjectProperty owlObjectProperty) {
                SelectedObjectPanel.this.objectDisplayLabel.setText("<html><body><b>Object property: </b>" + SelectedObjectPanel.this.owlEditorKit.getModelManager().getRendering(object) + "</body></html>");
            }

            public void visit(OWLOntology owlOntology) {
                SelectedObjectPanel.this.objectDisplayLabel.setText("<html><body><b>Ontology: </b>" + SelectedObjectPanel.this.owlEditorKit.getModelManager().getRendering((OWLObject)owlOntology) + "</body></html>");
            }
        });
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.owlEditorKit;
    }

    public OWLWorkspace getOWLWorkspace() {
        return this.getOWLEditorKit().getWorkspace();
    }

    public OWLModelManager getOWLModelManager() {
        return this.getOWLEditorKit().getModelManager();
    }
}

