/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import org.protege.editor.owl.ui.action.SelectedOWLClassAction;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.CollectionFactory;

public class ConvertToDefinedClassAction
extends SelectedOWLClassAction {
    @Override
    protected void initialiseAction() throws Exception {
    }

    public void actionPerformed(ActionEvent e) {
        OWLClass selClass = this.getOWLWorkspace().getOWLSelectionModel().getLastSelectedClass();
        ArrayList<Object> changes = new ArrayList<Object>();
        HashSet<OWLClassExpression> operands = new HashSet<OWLClassExpression>();
        for (OWLOntology ont : this.getOWLModelManager().getActiveOntologies()) {
            for (OWLSubClassOfAxiom ax : ont.getSubClassAxiomsForSubClass(selClass)) {
                changes.add(new RemoveAxiom(ont, (OWLAxiom)ax));
                operands.add(ax.getSuperClass());
            }
        }
        if (operands.isEmpty()) {
            return;
        }
        OWLDataFactory df = this.getOWLModelManager().getOWLDataFactory();
        Object equCls = operands.size() == 1 ? (OWLClassExpression)operands.iterator().next() : df.getOWLObjectIntersectionOf(operands);
        OWLEquivalentClassesAxiom ax = df.getOWLEquivalentClassesAxiom(CollectionFactory.createSet((Object[])new OWLClassExpression[]{selClass, equCls}));
        changes.add(new AddAxiom(this.getOWLModelManager().getActiveOntology(), (OWLAxiom)ax));
        this.getOWLModelManager().applyChanges(changes);
    }
}

