/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.protege.editor.owl.ui.action.SelectedOWLClassAction;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class ConvertToPrimitiveClassAction
extends SelectedOWLClassAction {
    public void actionPerformed(ActionEvent e) {
        OWLClass selCls = this.getOWLWorkspace().getOWLSelectionModel().getLastSelectedClass();
        if (selCls == null) {
            return;
        }
        OWLDataFactory dataFactory = this.getOWLModelManager().getOWLDataFactory();
        ArrayList<Object> changes = new ArrayList<Object>();
        for (OWLOntology ont : this.getOWLModelManager().getActiveOntologies()) {
            for (OWLEquivalentClassesAxiom ax : ont.getEquivalentClassesAxioms(selCls)) {
                changes.add(new RemoveAxiom(ont, (OWLAxiom)ax));
                for (OWLClassExpression desc : ax.getClassExpressions()) {
                    if (desc.equals(selCls)) continue;
                    if (desc instanceof OWLObjectIntersectionOf) {
                        for (OWLClassExpression op : ((OWLObjectIntersectionOf)desc).getOperands()) {
                            changes.add(new AddAxiom(ont, (OWLAxiom)dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)selCls, op)));
                        }
                        continue;
                    }
                    changes.add(new AddAxiom(ont, (OWLAxiom)dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)selCls, desc)));
                }
            }
        }
        this.getOWLModelManager().applyChanges(changes);
    }

    @Override
    protected void updateState() {
        OWLEntity selEnt = this.getOWLWorkspace().getOWLSelectionModel().getSelectedEntity();
        this.setEnabled(selEnt instanceof OWLClass);
    }

    @Override
    protected void initialiseAction() throws Exception {
    }

    @Override
    public void dispose() {
    }
}

