/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.entity.OWLEntityCreationSet;
import org.protege.editor.owl.ui.OWLEntityCreationPanel;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.action.SelectedOWLClassAction;
import org.protege.editor.owl.ui.renderer.OWLEntityAnnotationValueRenderer;
import org.protege.editor.owl.ui.renderer.OWLModelManagerEntityRenderer;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.semanticweb.owlapi.util.OWLObjectDuplicator;

public class DuplicateSelectedClassAction
extends SelectedOWLClassAction {
    private Preferences prefs;
    private static final String DUPLICATE_ANNOTATIONS_KEY = "DUPLICATE_ANNOTATIONS_KEY";
    private static final String DUPLICATE_INTO_ACTIVE_ONTOLOGY_KEY = "DUPLICATE_INTO_ACTIVE_ONTOLOGY_KEY";

    @Override
    protected void initialiseAction() throws Exception {
    }

    public void actionPerformed(ActionEvent e) {
        OWLClass selectedClass = this.getOWLWorkspace().getOWLSelectionModel().getLastSelectedClass();
        if (selectedClass != null) {
            this.prefs = PreferencesManager.getInstance().getApplicationPreferences(DuplicateSelectedClassAction.class);
            DuplicateClassPreferencesPanel panel = new DuplicateClassPreferencesPanel(selectedClass);
            UIHelper uiHelper = new UIHelper(this.getOWLEditorKit());
            if (uiHelper.showValidatingDialog("Duplicate Class", panel, panel.getFocusComponent()) == 0) {
                panel.saveSettings();
                OWLEntityCreationSet<OWLClass> set = panel.createOWLClass();
                if (set != null) {
                    HashMap<IRI, IRI> replacementIRIMap = new HashMap<IRI, IRI>();
                    replacementIRIMap.put(selectedClass.getIRI(), set.getOWLEntity().getIRI());
                    OWLModelManager mngr = this.getOWLModelManager();
                    OWLObjectDuplicator dup = new OWLObjectDuplicator(mngr.getOWLDataFactory(), replacementIRIMap);
                    ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>(set.getOntologyChanges());
                    changes.addAll(this.duplicateClassAxioms(selectedClass, dup));
                    if (this.prefs.getBoolean(DUPLICATE_ANNOTATIONS_KEY, false)) {
                        changes.addAll(this.duplicateAnnotations(selectedClass, dup));
                    }
                    mngr.applyChanges(changes);
                    this.getOWLWorkspace().getOWLSelectionModel().setSelectedEntity((OWLEntity)set.getOWLEntity());
                }
            }
        }
    }

    private List<OWLOntologyChange> duplicateClassAxioms(OWLClass selectedClass, OWLObjectDuplicator dup) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        boolean useActiveOnt = this.prefs.getBoolean(DUPLICATE_INTO_ACTIVE_ONTOLOGY_KEY, false);
        for (OWLOntology ont : this.getOWLModelManager().getActiveOntologies()) {
            for (OWLAxiom ax : ont.getAxioms(selectedClass)) {
                if (!ax.isLogicalAxiom() || ax instanceof OWLDisjointClassesAxiom) continue;
                OWLAxiom duplicatedAxiom = (OWLAxiom)dup.duplicateObject((OWLObject)ax);
                changes.add((OWLOntologyChange)new AddAxiom(useActiveOnt ? this.getOWLModelManager().getActiveOntology() : ont, duplicatedAxiom));
            }
        }
        return changes;
    }

    private List<OWLOntologyChange> duplicateAnnotations(OWLClass selectedClass, OWLObjectDuplicator dup) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        OWLModelManagerEntityRenderer ren = this.getOWLModelManager().getOWLEntityRenderer();
        List<IRI> annotIRIs = null;
        String selectedClassName = null;
        if (ren instanceof OWLEntityAnnotationValueRenderer) {
            selectedClassName = this.getOWLModelManager().getRendering((OWLObject)selectedClass);
            annotIRIs = OWLRendererPreferences.getInstance().getAnnotationIRIs();
        }
        LiteralExtractor literalExtractor = new LiteralExtractor();
        for (OWLOntology ont : this.getOWLModelManager().getActiveOntologies()) {
            for (OWLAnnotationAssertionAxiom ax : EntitySearcher.getAnnotationAssertionAxioms((OWLEntity)selectedClass, (OWLOntology)ont)) {
                String label;
                OWLAnnotation annot = ax.getAnnotation();
                if (annotIRIs != null && annotIRIs.contains(annot.getProperty().getIRI()) || (label = literalExtractor.getLiteral(annot.getValue())) != null && label.equals(selectedClassName)) continue;
                OWLAxiom duplicatedAxiom = (OWLAxiom)dup.duplicateObject((OWLObject)ax);
                changes.add((OWLOntologyChange)new AddAxiom(ont, duplicatedAxiom));
            }
        }
        return changes;
    }

    class DuplicateClassPreferencesPanel
    extends JComponent
    implements VerifiedInputEditor {
        private JCheckBox duplicateAnnotationsCheckbox;
        private JRadioButton activeOntologyButton;
        private JRadioButton originalOntologyButton;
        private OWLEntityCreationPanel<OWLClass> entityNamePanel;

        DuplicateClassPreferencesPanel(OWLClass selectedClass) {
            this.setLayout(new BorderLayout(6, 6));
            this.entityNamePanel = new OWLEntityCreationPanel<OWLClass>(DuplicateSelectedClassAction.this.getOWLEditorKit(), "Class name", OWLClass.class);
            this.entityNamePanel.setName(DuplicateSelectedClassAction.this.getOWLModelManager().getRendering((OWLObject)selectedClass));
            boolean duplicateIntoActiveOnt = DuplicateSelectedClassAction.this.prefs.getBoolean(DuplicateSelectedClassAction.DUPLICATE_INTO_ACTIVE_ONTOLOGY_KEY, false);
            this.activeOntologyButton = new JRadioButton("active ontology", duplicateIntoActiveOnt);
            this.originalOntologyButton = new JRadioButton("original ontology(ies)", !duplicateIntoActiveOnt);
            ButtonGroup group = new ButtonGroup();
            group.add(this.activeOntologyButton);
            group.add(this.originalOntologyButton);
            Box box = new Box(3);
            box.add(this.activeOntologyButton);
            box.add(this.originalOntologyButton);
            JPanel locationPanel = new JPanel(new BorderLayout(6, 6));
            locationPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            locationPanel.add((Component)new JLabel("Where you would like to duplicate the class?"), "North");
            locationPanel.add((Component)box, "Center");
            this.duplicateAnnotationsCheckbox = new JCheckBox("Duplicate annotations");
            this.duplicateAnnotationsCheckbox.setSelected(DuplicateSelectedClassAction.this.prefs.getBoolean(DuplicateSelectedClassAction.DUPLICATE_ANNOTATIONS_KEY, true));
            JPanel annotationPanel = new JPanel(new BorderLayout(6, 6));
            annotationPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            annotationPanel.add((Component)this.duplicateAnnotationsCheckbox, "West");
            this.add(this.entityNamePanel, "North");
            this.add((Component)locationPanel, "Center");
            this.add((Component)annotationPanel, "South");
        }

        public OWLEntityCreationSet<OWLClass> createOWLClass() {
            return this.entityNamePanel.getOWLEntityCreationSet();
        }

        public void saveSettings() {
            DuplicateSelectedClassAction.this.prefs.putBoolean(DuplicateSelectedClassAction.DUPLICATE_ANNOTATIONS_KEY, this.duplicateAnnotationsCheckbox.isSelected());
            DuplicateSelectedClassAction.this.prefs.putBoolean(DuplicateSelectedClassAction.DUPLICATE_INTO_ACTIVE_ONTOLOGY_KEY, this.activeOntologyButton.isSelected());
        }

        public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
            this.entityNamePanel.addStatusChangedListener(listener);
        }

        public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
            this.entityNamePanel.removeStatusChangedListener(listener);
        }

        public JComponent getFocusComponent() {
            return this.entityNamePanel.getFocusComponent();
        }
    }

    class LiteralExtractor
    implements OWLAnnotationValueVisitor {
        private String label;

        LiteralExtractor() {
        }

        public String getLiteral(OWLAnnotationValue value) {
            this.label = null;
            value.accept((OWLAnnotationValueVisitor)this);
            return this.label;
        }

        public void visit(IRI iri) {
        }

        public void visit(OWLAnonymousIndividual owlAnonymousIndividual) {
        }

        public void visit(OWLLiteral literal) {
            this.label = literal.getLiteral();
        }
    }
}

