/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action.export.inferred;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.protege.editor.owl.ui.action.export.inferred.InferredDisjointClassesAxiomGenerator;
import org.protege.editor.owl.ui.action.export.inferred.MonitoredInferredAxiomGenerator;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.util.InferredAxiomGenerator;
import org.semanticweb.owlapi.util.InferredClassAssertionAxiomGenerator;
import org.semanticweb.owlapi.util.InferredDataPropertyCharacteristicAxiomGenerator;
import org.semanticweb.owlapi.util.InferredEquivalentClassAxiomGenerator;
import org.semanticweb.owlapi.util.InferredEquivalentDataPropertiesAxiomGenerator;
import org.semanticweb.owlapi.util.InferredEquivalentObjectPropertyAxiomGenerator;
import org.semanticweb.owlapi.util.InferredInverseObjectPropertiesAxiomGenerator;
import org.semanticweb.owlapi.util.InferredObjectPropertyCharacteristicAxiomGenerator;
import org.semanticweb.owlapi.util.InferredPropertyAssertionGenerator;
import org.semanticweb.owlapi.util.InferredSubClassAxiomGenerator;
import org.semanticweb.owlapi.util.InferredSubDataPropertyAxiomGenerator;
import org.semanticweb.owlapi.util.InferredSubObjectPropertyAxiomGenerator;

public class ExportInferredOntologyPanel
extends JPanel {
    private static final long serialVersionUID = 2756557147241841849L;
    private Map<JCheckBox, InferredAxiomGenerator<? extends OWLAxiom>> map = new HashMap<JCheckBox, InferredAxiomGenerator<? extends OWLAxiom>>();
    private Box checkBoxBox = new Box(1);

    public static <A extends OWLAxiom> Set<InferenceType> getInferenceType(InferredAxiomGenerator<A> generator) {
        if (generator instanceof MonitoredInferredAxiomGenerator) {
            generator = ((MonitoredInferredAxiomGenerator)generator).getDelegate();
        }
        if (generator instanceof InferredSubClassAxiomGenerator || generator instanceof InferredEquivalentClassAxiomGenerator) {
            return EnumSet.of(InferenceType.CLASS_HIERARCHY);
        }
        if (generator instanceof InferredSubObjectPropertyAxiomGenerator || generator instanceof InferredEquivalentObjectPropertyAxiomGenerator || generator instanceof InferredInverseObjectPropertiesAxiomGenerator) {
            return EnumSet.of(InferenceType.OBJECT_PROPERTY_HIERARCHY);
        }
        if (generator instanceof InferredSubDataPropertyAxiomGenerator || generator instanceof InferredEquivalentDataPropertiesAxiomGenerator) {
            return EnumSet.of(InferenceType.DATA_PROPERTY_HIERARCHY);
        }
        if (generator instanceof InferredClassAssertionAxiomGenerator) {
            return EnumSet.of(InferenceType.CLASS_ASSERTIONS);
        }
        if (generator instanceof InferredPropertyAssertionGenerator) {
            return EnumSet.of(InferenceType.OBJECT_PROPERTY_ASSERTIONS, InferenceType.DATA_PROPERTY_ASSERTIONS);
        }
        if (generator instanceof InferredDisjointClassesAxiomGenerator) {
            return EnumSet.of(InferenceType.DISJOINT_CLASSES);
        }
        return EnumSet.noneOf(InferenceType.class);
    }

    public ExportInferredOntologyPanel() {
        this.setLayout(new BorderLayout(7, 7));
        this.add(this.checkBoxBox);
        this.addCheckBox((InferredAxiomGenerator<? extends OWLAxiom>)new InferredSubClassAxiomGenerator(), true, false);
        this.addCheckBox((InferredAxiomGenerator<? extends OWLAxiom>)new InferredEquivalentClassAxiomGenerator(), true, false);
        this.addCheckBox((InferredAxiomGenerator<? extends OWLAxiom>)new InferredSubObjectPropertyAxiomGenerator(), true, false);
        this.addCheckBox((InferredAxiomGenerator<? extends OWLAxiom>)new InferredSubDataPropertyAxiomGenerator(), true, false);
        this.addCheckBox((InferredAxiomGenerator<? extends OWLAxiom>)new InferredEquivalentObjectPropertyAxiomGenerator(), true, false);
        this.addCheckBox((InferredAxiomGenerator<? extends OWLAxiom>)new InferredEquivalentDataPropertiesAxiomGenerator(), true, false);
        this.addCheckBox((InferredAxiomGenerator<? extends OWLAxiom>)new InferredObjectPropertyCharacteristicAxiomGenerator(), false, false);
        this.addCheckBox((InferredAxiomGenerator<? extends OWLAxiom>)new InferredDataPropertyCharacteristicAxiomGenerator(), false, false);
        this.addCheckBox((InferredAxiomGenerator<? extends OWLAxiom>)new InferredInverseObjectPropertiesAxiomGenerator(), false, false);
        this.addCheckBox((InferredAxiomGenerator<? extends OWLAxiom>)new InferredClassAssertionAxiomGenerator(), false, false);
        this.addCheckBox((InferredAxiomGenerator<? extends OWLAxiom>)new InferredPropertyAssertionGenerator(), false, true);
        this.addCheckBox((InferredAxiomGenerator<? extends OWLAxiom>)new InferredDisjointClassesAxiomGenerator(), false, true);
    }

    private void addCheckBox(final InferredAxiomGenerator<? extends OWLAxiom> gen, boolean selected, boolean expensive) {
        String label = gen.getLabel();
        final JCheckBox box = new JCheckBox(label, selected);
        if (expensive) {
            box.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (box.isSelected()) {
                        JOptionPane.showMessageDialog(ExportInferredOntologyPanel.this, "<html><body>Warning: Exporting <b>" + gen.getLabel() + "</b> may take a long time.</body></html>", "Warning", 2);
                    }
                }
            });
        }
        this.checkBoxBox.add(box);
        this.checkBoxBox.add(Box.createVerticalStrut(4));
        this.map.put(box, gen);
    }

    public List<InferredAxiomGenerator<? extends OWLAxiom>> getInferredAxiomGenerators() {
        ArrayList<InferredAxiomGenerator<? extends OWLAxiom>> result = new ArrayList<InferredAxiomGenerator<? extends OWLAxiom>>();
        for (JCheckBox checkBox : this.map.keySet()) {
            if (!checkBox.isSelected()) continue;
            result.add(new MonitoredInferredAxiomGenerator<OWLAxiom>(this.map.get(checkBox)));
        }
        return result;
    }
}

