/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.axiom;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.util.OWLAxiomInstance;
import org.protege.editor.owl.ui.axiom.AxiomAnnotationsList;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;

public class AxiomAnnotationPanel
extends JComponent {
    private AxiomAnnotationsList annotationsComponent;
    private DefaultListModel model;

    public AxiomAnnotationPanel(OWLEditorKit eKit) {
        this.setLayout(new BorderLayout(6, 6));
        this.setPreferredSize(new Dimension(500, 300));
        OWLCellRenderer ren = new OWLCellRenderer(eKit);
        ren.setHighlightKeywords(true);
        this.model = new DefaultListModel();
        JList label = new JList(this.model);
        label.setBackground(this.getBackground());
        label.setEnabled(false);
        label.setOpaque(true);
        label.setCellRenderer(ren);
        this.annotationsComponent = new AxiomAnnotationsList(eKit);
        JScrollPane scroller = new JScrollPane((Component)((Object)this.annotationsComponent));
        this.add(label, "North");
        this.add((Component)scroller, "Center");
        this.setVisible(true);
    }

    public void setAxiomInstance(OWLAxiomInstance axiomInstance) {
        this.model.clear();
        if (axiomInstance != null) {
            this.model.addElement(axiomInstance.getAxiom());
            this.annotationsComponent.setRootObject(axiomInstance);
        } else {
            this.annotationsComponent.setRootObject(null);
        }
    }

    public OWLAxiomInstance getAxiom() {
        return (OWLAxiomInstance)this.annotationsComponent.getRoot();
    }

    public void dispose() {
        this.annotationsComponent.dispose();
    }
}

