/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.hierarchy.OWLAnnotationPropertyHierarchyProvider;
import org.protege.editor.owl.ui.editor.AbstractOWLObjectEditor;
import org.protege.editor.owl.ui.editor.IRIFromEntityEditor;
import org.protege.editor.owl.ui.editor.IRITextEditor;
import org.protege.editor.owl.ui.editor.OWLAnonymousIndividualAnnotationValueEditor;
import org.protege.editor.owl.ui.editor.OWLConstantEditor;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.selector.OWLAnnotationPropertySelectorPanel;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class OWLAnnotationEditor
extends AbstractOWLObjectEditor<OWLAnnotation>
implements VerifiedInputEditor {
    protected final OWLEditorKit owlEditorKit;
    private JTabbedPane tabbedPane;
    private JPanel mainPanel;
    private OWLAnnotationPropertySelectorPanel annotationPropertySelector;
    private List<OWLObjectEditor<? extends OWLAnnotationValue>> editors;
    private OWLAnnotationProperty lastSelectedProperty;
    private List<InputVerificationStatusChangedListener> verificationListeners = new ArrayList<InputVerificationStatusChangedListener>();
    private boolean status = false;
    private static String lastEditorName = "";
    private ChangeListener changeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent event) {
            OWLAnnotationEditor.this.verify();
        }
    };
    private InputVerificationStatusChangedListener mergedVerificationListener = new InputVerificationStatusChangedListener(){

        public void verifiedStatusChanged(boolean newState) {
            for (InputVerificationStatusChangedListener listener : OWLAnnotationEditor.this.verificationListeners) {
                listener.verifiedStatusChanged(newState);
            }
        }
    };

    public OWLAnnotationEditor(OWLEditorKit owlEditorKit) {
        this.owlEditorKit = owlEditorKit;
        this.tabbedPane = new JTabbedPane();
        this.mainPanel = new VerifiedInputJPanel();
        this.mainPanel.setLayout(new BorderLayout());
        JSplitPane splitPane = new JSplitPane(1);
        this.mainPanel.add(splitPane);
        this.annotationPropertySelector = this.createAnnotationPropertySelector();
        JPanel listHolder = new JPanel(new BorderLayout());
        listHolder.add(this.annotationPropertySelector);
        listHolder.setPreferredSize(new Dimension(200, 300));
        splitPane.setLeftComponent(listHolder);
        splitPane.setRightComponent(this.tabbedPane);
        splitPane.setBorder(null);
        this.loadEditors();
        this.initialiseLastSelectedProperty();
        this.annotationPropertySelector.addSelectionListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                OWLAnnotationEditor.this.verify();
            }
        });
        this.tabbedPane.addChangeListener(this.changeListener);
    }

    protected final void initialiseLastSelectedProperty() {
        assert (this.lastSelectedProperty == null);
        this.lastSelectedProperty = this.getDefaultAnnotationProperty();
    }

    protected OWLAnnotationProperty getDefaultAnnotationProperty() {
        OWLModelManager mngr = this.owlEditorKit.getOWLModelManager();
        return mngr.getOWLDataFactory().getOWLAnnotationProperty(OWLRDFVocabulary.RDFS_COMMENT.getIRI());
    }

    protected OWLAnnotationPropertySelectorPanel createAnnotationPropertySelector() {
        OWLModelManager mngr = this.owlEditorKit.getOWLModelManager();
        OWLAnnotationPropertyHierarchyProvider hp = mngr.getOWLHierarchyManager().getOWLAnnotationPropertyHierarchyProvider();
        return new OWLAnnotationPropertySelectorPanel(this.owlEditorKit, true, hp);
    }

    private void loadEditors() {
        this.editors = this.createEditors();
        assert (!this.editors.isEmpty());
        int selIndex = 0;
        int tabCount = 0;
        for (OWLObjectEditor<? extends OWLAnnotationValue> editor : this.editors) {
            String editorTypeName = editor.getEditorTypeName();
            this.tabbedPane.add(editorTypeName, editor.getEditorComponent());
            if (lastEditorName != null && editorTypeName != null && lastEditorName.equals(editorTypeName)) {
                selIndex = tabCount;
            }
            ++tabCount;
        }
        this.tabbedPane.setSelectedIndex(selIndex);
    }

    protected List<OWLObjectEditor<? extends OWLAnnotationValue>> createEditors() {
        IRIFromEntityEditor iriEditor = new IRIFromEntityEditor(this.owlEditorKit);
        iriEditor.addSelectionListener(this.changeListener);
        OWLConstantEditor constantEditor = new OWLConstantEditor(this.owlEditorKit);
        OWLAnonymousIndividualAnnotationValueEditor anonIndividualEditor = new OWLAnonymousIndividualAnnotationValueEditor(this.owlEditorKit);
        IRITextEditor textEditor = new IRITextEditor(this.owlEditorKit);
        textEditor.addStatusChangedListener(this.mergedVerificationListener);
        ArrayList<OWLObjectEditor<? extends OWLAnnotationValue>> result = new ArrayList<OWLObjectEditor<? extends OWLAnnotationValue>>();
        result.add(constantEditor);
        result.add(iriEditor);
        result.add(textEditor);
        result.add(anonIndividualEditor);
        return result;
    }

    protected OWLObjectEditor<? extends OWLAnnotationValue> getSelectedEditor() {
        return this.editors.get(this.tabbedPane.getSelectedIndex());
    }

    @Override
    public boolean setEditedObject(OWLAnnotation annotation) {
        int tabIndex = -1;
        if (annotation != null) {
            this.annotationPropertySelector.setSelection(annotation.getProperty());
            for (int i = 0; i < this.editors.size(); ++i) {
                OWLObjectEditor<? extends OWLAnnotationValue> editor = this.editors.get(i);
                if (editor.canEdit(annotation.getValue())) {
                    editor.setEditedObject((OWLAnnotationValue)annotation.getValue());
                    if (tabIndex != -1) continue;
                    tabIndex = i;
                    continue;
                }
                editor.setEditedObject(null);
            }
        } else {
            this.annotationPropertySelector.setSelection(this.lastSelectedProperty);
            for (int i = 0; i < this.editors.size(); ++i) {
                OWLObjectEditor<? extends OWLAnnotationValue> editor = this.editors.get(i);
                editor.setEditedObject(null);
                if (!lastEditorName.equals(editor.getEditorTypeName())) continue;
                tabIndex = i;
            }
        }
        this.tabbedPane.setSelectedIndex(tabIndex == -1 ? 0 : tabIndex);
        return true;
    }

    public OWLAnnotation getAnnotation() {
        OWLAnnotationProperty property = this.annotationPropertySelector.getSelectedObject();
        if (property != null) {
            this.lastSelectedProperty = property;
            lastEditorName = this.getSelectedEditor().getEditorTypeName();
            OWLDataFactory dataFactory = this.owlEditorKit.getModelManager().getOWLDataFactory();
            OWLAnnotationValue obj = this.getSelectedEditor().getEditedObject();
            if (obj != null) {
                return dataFactory.getOWLAnnotation(property, obj);
            }
        }
        return null;
    }

    @Override
    public String getEditorTypeName() {
        return "OWL Annotation";
    }

    @Override
    public boolean canEdit(Object object) {
        return object instanceof OWLAnnotation;
    }

    @Override
    public JComponent getEditorComponent() {
        return this.mainPanel;
    }

    public JComponent getInlineEditorComponent() {
        return this.getEditorComponent();
    }

    @Override
    public OWLAnnotation getEditedObject() {
        return this.getAnnotation();
    }

    @Override
    public void dispose() {
        this.annotationPropertySelector.dispose();
        for (OWLObjectEditor<? extends OWLAnnotationValue> editor : this.editors) {
            editor.dispose();
        }
    }

    private void verify() {
        if (this.status != this.isValid()) {
            this.status = this.isValid();
            for (InputVerificationStatusChangedListener l : this.verificationListeners) {
                l.verifiedStatusChanged(this.status);
            }
        }
    }

    private boolean isValid() {
        return this.annotationPropertySelector.getSelectedObject() != null && this.getSelectedEditor().getEditedObject() != null;
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.verificationListeners.add(listener);
        listener.verifiedStatusChanged(this.isValid());
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.verificationListeners.remove(listener);
    }

    protected final OWLAnnotationProperty getLastSelectedProperty() {
        return this.lastSelectedProperty;
    }

    protected final OWLAnnotationPropertySelectorPanel getAnnotationPropertySelector() {
        return this.annotationPropertySelector;
    }

    private class VerifiedInputJPanel
    extends JPanel
    implements VerifiedInputEditor {
        private static final long serialVersionUID = -6537871629287844213L;

        private VerifiedInputJPanel() {
        }

        public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
            OWLAnnotationEditor.this.addStatusChangedListener(listener);
        }

        public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
            OWLAnnotationEditor.this.removeStatusChangedListener(listener);
        }
    }
}

