/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.AbstractOWLObjectEditor;
import org.protege.editor.owl.ui.editor.OWLClassExpressionEditor;
import org.semanticweb.owlapi.model.OWLClassExpression;

public class OWLClassDescriptionEditor
extends AbstractOWLObjectEditor<OWLClassExpression>
implements VerifiedInputEditor {
    public static final String PREFERRED_CLASS_EXPRESSION_EDITOR = "preferred.class.expression.editor";
    private JComponent editingComponent;
    private JTabbedPane tabbedPane;
    private List<OWLClassExpressionEditor> activeEditors = new ArrayList<OWLClassExpressionEditor>();
    private Set<OWLClassExpressionEditor> editors = new HashSet<OWLClassExpressionEditor>();
    private boolean currentStatus = false;
    private Set<InputVerificationStatusChangedListener> listeners = new HashSet<InputVerificationStatusChangedListener>();
    private ChangeListener changeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            OWLClassDescriptionEditor.this.handleVerifyEditorContents();
        }
    };
    private OWLClassExpression expression;
    private InputVerificationStatusChangedListener inputListener = new InputVerificationStatusChangedListener(){

        public void verifiedStatusChanged(boolean newState) {
            OWLClassDescriptionEditor.this.handleVerifyEditorContents();
        }
    };
    private Preferences preferences = PreferencesManager.getInstance().getApplicationPreferences(OWLClassDescriptionEditor.class);

    public OWLClassDescriptionEditor(OWLEditorKit editorKit, OWLClassExpression expression) {
        this.expression = expression;
        this.editingComponent = new JPanel(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setFocusable(false);
        this.editingComponent.add(this.tabbedPane);
        this.editingComponent.setPreferredSize(new Dimension(600, 400));
        this.tabbedPane.addChangeListener(this.changeListener);
    }

    public void addPanel(OWLClassExpressionEditor editorPanel) {
        this.editors.add(editorPanel);
        if (editorPanel.setDescription(this.expression)) {
            this.activeEditors.add(editorPanel);
            this.tabbedPane.add(editorPanel.getEditorName(), editorPanel.getComponent());
            editorPanel.addStatusChangedListener(this.inputListener);
            this.tabbedPane.setSelectedIndex(0);
        }
    }

    private void handleVerifyEditorContents() {
        boolean newStatus;
        this.currentStatus = newStatus = this.isValidated();
        for (InputVerificationStatusChangedListener l : this.listeners) {
            l.verifiedStatusChanged(newStatus);
        }
    }

    private boolean isValidated() {
        OWLClassExpressionEditor editor = this.getSelectedEditor();
        return editor != null && editor.isValidInput();
    }

    @Override
    public String getEditorTypeName() {
        return "Class expression";
    }

    @Override
    public boolean canEdit(Object object) {
        return object instanceof OWLClassExpression;
    }

    @Override
    public JComponent getEditorComponent() {
        return this.editingComponent;
    }

    @Override
    public boolean setEditedObject(OWLClassExpression expression) {
        this.expression = expression;
        this.activeEditors.clear();
        this.tabbedPane.removeChangeListener(this.changeListener);
        this.tabbedPane.removeAll();
        for (OWLClassExpressionEditor editor : this.editors) {
            if (!editor.setDescription(this.expression)) continue;
            this.activeEditors.add(editor);
            this.tabbedPane.add(editor.getEditorName(), editor.getComponent());
            editor.addStatusChangedListener(this.inputListener);
        }
        this.tabbedPane.validate();
        this.tabbedPane.addChangeListener(this.changeListener);
        this.selectPreferredEditor();
        return !this.activeEditors.isEmpty();
    }

    @Override
    public OWLClassExpression getEditedObject() {
        this.setSelectedEditorPreferred();
        Set<OWLClassExpression> sel = this.getSelectedEditor().getClassExpressions();
        if (sel.isEmpty()) {
            return null;
        }
        return sel.iterator().next();
    }

    @Override
    public Set<OWLClassExpression> getEditedObjects() {
        this.setSelectedEditorPreferred();
        return this.getSelectedEditor().getClassExpressions();
    }

    private OWLClassExpressionEditor getSelectedEditor() {
        int index = this.tabbedPane.getSelectedIndex();
        if (index < 0) {
            index = 0;
        }
        return !this.activeEditors.isEmpty() ? this.activeEditors.get(index) : null;
    }

    public void setSelectedEditor(OWLClassExpressionEditor editor) {
        int index = this.activeEditors.indexOf(editor);
        if (index >= 0) {
            this.tabbedPane.setSelectedIndex(index);
        }
    }

    private void setSelectedEditorPreferred() {
        OWLClassExpressionEditor editor = this.getSelectedEditor();
        this.preferences.putString(PREFERRED_CLASS_EXPRESSION_EDITOR, editor.getClass().getCanonicalName());
    }

    public void selectPreferredEditor() {
        String preferredEditor = this.preferences.getString(PREFERRED_CLASS_EXPRESSION_EDITOR, null);
        if (preferredEditor != null) {
            int index = 0;
            for (OWLClassExpressionEditor editor : this.activeEditors) {
                if (preferredEditor.equals(editor.getClass().getCanonicalName())) {
                    this.tabbedPane.setSelectedIndex(index);
                    break;
                }
                ++index;
            }
        }
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener l) {
        this.listeners.add(l);
        l.verifiedStatusChanged(this.isValidated());
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void dispose() {
        for (OWLClassExpressionEditor editor : this.editors) {
            try {
                editor.dispose();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

