/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.AbstractOWLObjectEditor;
import org.protege.editor.owl.ui.selector.OWLDataPropertySelectorPanel;
import org.semanticweb.owlapi.model.OWLDataProperty;

public class OWLDataPropertyEditor
extends AbstractOWLObjectEditor<OWLDataProperty>
implements VerifiedInputEditor {
    private OWLDataPropertySelectorPanel editor;
    private Set<InputVerificationStatusChangedListener> listeners = new HashSet<InputVerificationStatusChangedListener>();
    private InputVerificationStatusChangedListener inputListener = new InputVerificationStatusChangedListener(){

        public void verifiedStatusChanged(boolean newState) {
            OWLDataPropertyEditor.this.handleVerifyEditorContents();
        }
    };

    public OWLDataPropertyEditor(OWLEditorKit owlEditorKit) {
        this.editor = new OWLDataPropertySelectorPanel(owlEditorKit);
        this.editor.addStatusChangedListener(this.inputListener);
    }

    @Override
    public OWLDataProperty getEditedObject() {
        return this.editor.getSelectedObject();
    }

    @Override
    public boolean setEditedObject(OWLDataProperty p) {
        this.editor.setSelection(p);
        return true;
    }

    @Override
    public String getEditorTypeName() {
        return "Data property";
    }

    @Override
    public boolean canEdit(Object object) {
        return object instanceof OWLDataProperty;
    }

    @Override
    public JComponent getEditorComponent() {
        return this.editor;
    }

    private void handleVerifyEditorContents() {
        for (InputVerificationStatusChangedListener l : this.listeners) {
            l.verifiedStatusChanged(true);
        }
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener l) {
        this.listeners.add(l);
        l.verifiedStatusChanged(true);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void dispose() {
        this.editor.dispose();
    }
}

