/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.clsdescriptioneditor.ExpressionEditor;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLDataRangeChecker;
import org.protege.editor.owl.ui.editor.AbstractOWLObjectEditor;
import org.protege.editor.owl.ui.selector.OWLDataTypeSelectorPanel;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLException;

public class OWLDataRangeEditor
extends AbstractOWLObjectEditor<OWLDataRange> {
    private JPanel editorPanel = new JPanel(new BorderLayout(7, 7));
    private JTabbedPane tabbedPane = new JTabbedPane();
    private OWLDataTypeSelectorPanel datatypeList;
    private ExpressionEditor<OWLDataRange> expressionEditor;
    private JScrollPane expressionScroller;

    public OWLDataRangeEditor(OWLEditorKit owlEditorKit) {
        this.editorPanel.add(this.tabbedPane);
        this.datatypeList = new OWLDataTypeSelectorPanel(owlEditorKit);
        this.tabbedPane.add("Built in datatypes", this.datatypeList);
        this.expressionEditor = new ExpressionEditor<OWLDataRange>(owlEditorKit, new OWLDataRangeChecker(owlEditorKit.getOWLModelManager()));
        this.expressionScroller = new JScrollPane(this.expressionEditor);
        this.tabbedPane.add("Data range expression", this.expressionScroller);
        this.tabbedPane.setPreferredSize(new Dimension(400, 600));
    }

    @Override
    public boolean setEditedObject(OWLDataRange dataRange) {
        this.expressionEditor.setExpressionObject(dataRange);
        if (dataRange != null && dataRange.isDatatype()) {
            this.datatypeList.setSelection((OWLDatatype)dataRange);
            this.tabbedPane.setSelectedComponent(this.datatypeList);
        } else {
            this.datatypeList.setSelection((OWLDatatype)null);
            this.tabbedPane.setSelectedComponent(this.expressionScroller);
        }
        return true;
    }

    @Override
    public String getEditorTypeName() {
        return "Data Range";
    }

    @Override
    public boolean canEdit(Object object) {
        return object instanceof OWLDataRange;
    }

    @Override
    public JComponent getEditorComponent() {
        return this.editorPanel;
    }

    @Override
    public OWLDataRange getEditedObject() {
        if (this.tabbedPane.getSelectedComponent() == this.datatypeList) {
            return this.datatypeList.getSelectedObject();
        }
        if (this.expressionEditor.isWellFormed()) {
            try {
                return this.expressionEditor.createObject();
            }
            catch (OWLException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public void dispose() {
    }
}

