/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.protege.editor.core.ui.util.AugmentedJTextField;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.classexpression.OWLExpressionParserException;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLAutoCompleter;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLExpressionChecker;
import org.protege.editor.owl.ui.editor.AbstractOWLObjectEditor;
import org.protege.editor.owl.ui.frame.OWLObjectPropertyIndividualPair;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;

public class OWLObjectPropertyIndividualPairEditor2
extends AbstractOWLObjectEditor<OWLObjectPropertyIndividualPair> {
    private JTextField objectPropertyField;
    private JTextField individualField;
    private JPanel panel;
    private OWLModelManager modelManager;

    public OWLObjectPropertyIndividualPairEditor2(OWLEditorKit editorKit) {
        this.modelManager = editorKit.getOWLModelManager();
        this.panel = new JPanel(new GridBagLayout());
        this.objectPropertyField = new AugmentedJTextField("", 20, "Enter object property name");
        this.individualField = new AugmentedJTextField("", 20, "Enter individual name");
        Insets insets = new Insets(2, 2, 2, 2);
        this.panel.add((Component)this.objectPropertyField, new GridBagConstraints(0, 0, 1, 1, 100.0, 0.0, 256, 2, insets, 0, 0));
        this.panel.add((Component)this.individualField, new GridBagConstraints(1, 0, 1, 1, 100.0, 0.0, 256, 2, insets, 0, 0));
        JLabel tipLabel = new JLabel("(Tip: Use CTRL+Space to auto-complete names)");
        tipLabel.setForeground(Color.GRAY);
        tipLabel.setHorizontalAlignment(4);
        this.panel.add((Component)tipLabel, new GridBagConstraints(0, 1, 2, 1, 100.0, 0.0, 768, 2, insets, 0, 0));
        new OWLAutoCompleter(editorKit, this.objectPropertyField, new OWLExpressionChecker(){

            @Override
            public void check(String text) throws OWLExpressionParserException {
                if (OWLObjectPropertyIndividualPairEditor2.this.modelManager.getOWLEntityFinder().getOWLObjectProperty(text) == null) {
                    throw new OWLExpressionParserException(text, 0, text.length(), false, true, false, false, false, false, Collections.emptySet());
                }
            }

            public Object createObject(String text) throws OWLExpressionParserException {
                return OWLObjectPropertyIndividualPairEditor2.this.modelManager.getOWLEntityFinder().getOWLObjectProperty(text);
            }
        });
        new OWLAutoCompleter(editorKit, this.individualField, new OWLExpressionChecker(){

            @Override
            public void check(String text) throws OWLExpressionParserException {
                if (OWLObjectPropertyIndividualPairEditor2.this.modelManager.getOWLEntityFinder().getOWLIndividual(text) == null) {
                    throw new OWLExpressionParserException(text, 0, text.length(), false, false, false, true, false, false, Collections.emptySet());
                }
            }

            public Object createObject(String text) throws OWLExpressionParserException {
                return OWLObjectPropertyIndividualPairEditor2.this.modelManager.getOWLEntityFinder().getOWLIndividual(text);
            }
        });
    }

    @Override
    public String getEditorTypeName() {
        return "Object property assertion";
    }

    @Override
    public boolean canEdit(Object object) {
        return object instanceof OWLObjectPropertyIndividualPair;
    }

    @Override
    public JComponent getEditorComponent() {
        return this.panel;
    }

    @Override
    public OWLObjectPropertyIndividualPair getEditedObject() {
        OWLObjectProperty property = this.modelManager.getOWLEntityFinder().getOWLObjectProperty(this.objectPropertyField.getText());
        if (property == null) {
            return null;
        }
        OWLNamedIndividual individual = this.modelManager.getOWLEntityFinder().getOWLIndividual(this.individualField.getText());
        if (individual == null) {
            return null;
        }
        return new OWLObjectPropertyIndividualPair((OWLObjectPropertyExpression)property, (OWLIndividual)individual);
    }

    @Override
    public boolean setEditedObject(OWLObjectPropertyIndividualPair editedObject) {
        if (editedObject == null) {
            this.objectPropertyField.setText("");
            this.individualField.setText("");
        } else {
            this.objectPropertyField.setText(this.modelManager.getRendering((OWLObject)editedObject.getProperty()));
            this.individualField.setText(this.modelManager.getRendering((OWLObject)editedObject.getIndividual()));
        }
        return true;
    }

    @Override
    public void dispose() {
    }
}

