/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.error;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import org.protege.editor.core.ui.error.ErrorExplainer;

public class ErrorPanel<O extends Throwable>
extends JPanel {
    private JTextComponent stackTracePane;
    protected JComponent errorMessageComponent;
    private JComponent stackTraceComponent;
    private JTabbedPane tabs;

    public ErrorPanel(ErrorExplainer.ErrorExplanation<O> explanation, URI loc) {
        this.setLayout(new BorderLayout(12, 12));
        this.setBorder(new EmptyBorder(7, 7, 7, 7));
        JEditorPane errorMessagePanel = new JEditorPane();
        errorMessagePanel.setEditable(false);
        errorMessagePanel.setText(explanation.getMessage());
        errorMessagePanel.setBorder(new EmptyBorder(7, 7, 7, 7));
        JScrollPane errorScroller = new JScrollPane(errorMessagePanel);
        this.stackTracePane = new JTextArea(20, 60);
        this.setErrorMessage(this.stackTracePane, explanation.getCause());
        this.stackTracePane.setBorder(new EmptyBorder(7, 7, 7, 7));
        JScrollPane stackTraceScroller = new JScrollPane(this.stackTracePane);
        this.tabs = new JTabbedPane();
        this.tabs.addTab("Error", errorScroller);
        this.tabs.addTab("Stack Trace", stackTraceScroller);
        this.add((Component)this.tabs, "Center");
    }

    protected void setErrorMessage(JTextComponent component, Throwable exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        String message = exception.getMessage();
        if (message != null) {
            writer.write(message);
            writer.write("\n\n\n");
        }
        writer.write("Full Stack Trace\n-----------------------------------------------------------------------------------------\n\n");
        exception.printStackTrace(writer);
        writer.flush();
        component.setText(stringWriter.toString());
        component.setCaretPosition(0);
    }

    protected JComponent getTabs() {
        return this.tabs;
    }
}

