/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.error;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.obolibrary.oboformat.parser.OBOFormatParser;
import org.obolibrary.oboformat.parser.OBOFormatParserException;
import org.protege.editor.core.ui.error.ErrorExplainer;
import org.protege.editor.core.ui.util.JOptionPaneEx;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.error.ErrorPanel;
import org.protege.editor.owl.ui.error.OntologyLoadErrorHandler;
import org.protege.editor.owl.ui.error.ParseErrorPanel;
import org.semanticweb.owlapi.expression.ParserException;
import org.semanticweb.owlapi.formats.FunctionalSyntaxDocumentFormat;
import org.semanticweb.owlapi.formats.ManchesterSyntaxDocumentFormat;
import org.semanticweb.owlapi.formats.OBODocumentFormat;
import org.semanticweb.owlapi.formats.OWLXMLDocumentFormat;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.formats.TurtleDocumentFormat;
import org.semanticweb.owlapi.functional.parser.OWLFunctionalSyntaxOWLParser;
import org.semanticweb.owlapi.io.OWLParser;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.io.UnparsableOntologyException;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.owlxml.parser.OWLXMLParser;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFParserException;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFXMLParser;
import org.semanticweb.owlapi.rdf.turtle.parser.TurtleOntologyParser;
import org.semanticweb.owlapi.util.mansyntax.ManchesterOWLSyntaxParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntologyLoadErrorHandlerUI
implements OntologyLoadErrorHandler {
    public final Logger logger = LoggerFactory.getLogger(OntologyLoadErrorHandlerUI.class);
    private OWLEditorKit eKit;
    private String lastSelectedParser = null;
    private ErrorExplainer errorExplainer;
    private boolean reload = false;

    public OntologyLoadErrorHandlerUI(OWLEditorKit owlEditorKit) {
        this.eKit = owlEditorKit;
    }

    public boolean getReloadFlag() {
        return this.reload;
    }

    public void setReloadFlag(boolean reload) {
        this.reload = reload;
    }

    @Override
    public <T extends Throwable> void handleErrorLoadingOntology(OWLOntologyID ontologyID, URI loc, T e) throws Throwable {
        int retVal;
        OPTIONS[] options = OPTIONS.values();
        if (e instanceof UnparsableOntologyException) {
            this.errorExplainer = this.createErrorExplainer();
            ParseErrorsPanel errorPanel = new ParseErrorsPanel((UnparsableOntologyException)e, loc);
            retVal = JOptionPaneEx.showConfirmDialog((Component)((Object)this.eKit.getWorkspace()), (String)("Load Error: " + ontologyID), (JComponent)errorPanel, (int)0, (int)-1, null, (Object[])options, (Object)((Object)OPTIONS.OK));
            this.lastSelectedParser = errorPanel.tabs.getTitleAt(errorPanel.tabs.getSelectedIndex());
        } else {
            ErrorExplainer.ErrorExplanation explanation = new ErrorExplainer().getErrorExplanation(e, true);
            ErrorPanel errorPanel = new ErrorPanel(explanation, loc);
            this.logger.warn(explanation.getMessage(), explanation.getCause());
            retVal = JOptionPaneEx.showConfirmDialog((Component)((Object)this.eKit.getWorkspace()), (String)("Load Error: " + ontologyID), errorPanel, (int)0, (int)-1, null, (Object[])options, (Object)((Object)OPTIONS.OK));
        }
        if (retVal == OPTIONS.RELOAD.ordinal()) {
            this.setReloadFlag(true);
        }
    }

    private ErrorExplainer createErrorExplainer() {
        ErrorExplainer errorFilter = new ErrorExplainer();
        errorFilter.addExplanationFactory(RDFParserException.class, (ErrorExplainer.ErrorExplanationFactory)new ErrorExplainer.ErrorExplanationFactory<RDFParserException>(){

            public <T extends RDFParserException> ErrorExplainer.ErrorExplanation<T> createExplanation(T throwable) {
                return new ErrorExplainer.ParseErrorExplanation(throwable, throwable.getMessage(), throwable.getLineNumber(), throwable.getColumnNumber());
            }
        });
        ErrorExplainer.ErrorExplanationFactory<OWLParserException> owlParserExceptionExplanationFac = new ErrorExplainer.ErrorExplanationFactory<OWLParserException>(){

            public <T extends OWLParserException> ErrorExplainer.ErrorExplanation<T> createExplanation(T throwable) {
                return new ErrorExplainer.ParseErrorExplanation(throwable, throwable.getMessage(), throwable.getLineNumber(), 0);
            }
        };
        errorFilter.addExplanationFactory(OWLParserException.class, (ErrorExplainer.ErrorExplanationFactory)owlParserExceptionExplanationFac);
        errorFilter.addExplanationFactory(OBOFormatParserException.class, (ErrorExplainer.ErrorExplanationFactory)owlParserExceptionExplanationFac);
        errorFilter.addExplanationFactory(ParserException.class, (ErrorExplainer.ErrorExplanationFactory)new ErrorExplainer.ErrorExplanationFactory<ParserException>(){

            public <T extends ParserException> ErrorExplainer.ErrorExplanation<T> createExplanation(T throwable) {
                return new ErrorExplainer.ParseErrorExplanation(throwable, throwable.getMessage(), throwable.getLineNumber(), throwable.getColumnNumber());
            }
        });
        return errorFilter;
    }

    public class ParseErrorsPanel
    extends JPanel {
        private JTabbedPane tabs;
        private Map<Class<? extends OWLDocumentFormat>, String> format2ParserMap = new HashMap<Class<? extends OWLDocumentFormat>, String>();

        public ParseErrorsPanel(UnparsableOntologyException e, URI loc) {
            this.setLayout(new BorderLayout(12, 12));
            this.format2ParserMap.put(RDFXMLDocumentFormat.class, RDFXMLParser.class.getSimpleName());
            this.format2ParserMap.put(OWLXMLDocumentFormat.class, OWLXMLParser.class.getSimpleName());
            this.format2ParserMap.put(ManchesterSyntaxDocumentFormat.class, ManchesterOWLSyntaxParser.class.getSimpleName());
            this.format2ParserMap.put(TurtleDocumentFormat.class, TurtleOntologyParser.class.getSimpleName());
            this.format2ParserMap.put(FunctionalSyntaxDocumentFormat.class, OWLFunctionalSyntaxOWLParser.class.getSimpleName());
            this.format2ParserMap.put(OBODocumentFormat.class, OBOFormatParser.class.getSimpleName());
            this.tabs = new JTabbedPane();
            this.tabs.setPreferredSize(new Dimension(700, 500));
            ArrayList parsers = new ArrayList(e.getExceptions().keySet());
            for (OWLParser parser : parsers) {
                Throwable parseError = (Throwable)e.getExceptions().get(parser);
                ErrorExplainer.ErrorExplanation explanation = OntologyLoadErrorHandlerUI.this.errorExplainer.getErrorExplanation(parseError, true);
                ParseErrorPanel errorPanel = new ParseErrorPanel(explanation, loc);
                this.tabs.addTab(parser.getClass().getSimpleName(), errorPanel);
            }
            this.add((Component)new JLabel("<html>Could not parse the ontology found at: " + loc + "<p>The following parsers were tried:</html>"), "North");
            this.add((Component)this.tabs, "Center");
        }
    }

    private static enum OPTIONS {
        OK("OK"),
        RELOAD("Reload");

        private String name;

        private OPTIONS(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

