/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.protege.editor.core.ui.list.MListButton;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.editor.OWLObjectEditorHandler;
import org.protege.editor.owl.ui.frame.OWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;

public abstract class AbstractOWLFrameSectionRow<R, A extends OWLAxiom, E>
implements OWLFrameSectionRow<R, A, E>,
OWLObjectEditorHandler<E> {
    public static final String DEFAULT_DELIMETER = ", ";
    public static final String DEFAULT_PREFIX = "";
    public static final String DEFAULT_SUFFIX = "";
    private OWLEditorKit owlEditorKit;
    private OWLOntology ontology;
    private R rootObject;
    protected A axiom;
    private Object userObject;
    private OWLFrameSection section;

    protected AbstractOWLFrameSectionRow(OWLEditorKit owlEditorKit, OWLFrameSection<R, A, E> section, OWLOntology ontology, R rootObject, A axiom) {
        this.owlEditorKit = owlEditorKit;
        this.section = section;
        this.ontology = ontology;
        this.rootObject = rootObject;
        this.axiom = axiom;
    }

    @Override
    public OWLFrameSection<R, A, E> getFrameSection() {
        return this.section;
    }

    public R getRootObject() {
        return this.rootObject;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public boolean isFixedHeight() {
        return false;
    }

    @Override
    public final OWLObjectEditor<E> getEditor() {
        OWLObjectEditor<E> editor = this.getObjectEditor();
        if (editor != null) {
            editor.setHandler(this);
        }
        return editor;
    }

    protected abstract OWLObjectEditor<E> getObjectEditor();

    @Override
    public boolean checkEditorResults(OWLObjectEditor<E> editor) {
        return true;
    }

    @Override
    public void handleEditingFinished(Set<E> editedObjects) {
        if (editedObjects.isEmpty()) {
            return;
        }
        Object newAxiom = this.createAxiom(editedObjects.iterator().next());
        if (newAxiom != null) {
            A oldAxiom = this.getAxiom();
            Set axiomAnnotations = oldAxiom.getAnnotations();
            if (axiomAnnotations != null && !axiomAnnotations.isEmpty()) {
                newAxiom = newAxiom.getAnnotatedAxiom(axiomAnnotations);
            }
            ArrayList<Object> changes = new ArrayList<Object>();
            changes.add(new RemoveAxiom(this.getOntology(), oldAxiom));
            changes.add(new AddAxiom(this.getOntology(), newAxiom));
            this.getOWLModelManager().applyChanges(changes);
        }
    }

    protected abstract A createAxiom(E var1);

    @Override
    public OWLOntology getOntology() {
        return this.ontology;
    }

    public OWLModelManager getOWLModelManager() {
        return this.owlEditorKit.getModelManager();
    }

    public OWLDataFactory getOWLDataFactory() {
        return this.getOWLModelManager().getOWLDataFactory();
    }

    @Override
    public OWLOntologyManager getOWLOntologyManager() {
        return this.getOWLModelManager().getOWLOntologyManager();
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.owlEditorKit;
    }

    @Override
    public R getRoot() {
        return this.rootObject;
    }

    @Override
    public A getAxiom() {
        return this.axiom;
    }

    @Override
    public boolean canAcceptDrop(List<OWLObject> objects) {
        return false;
    }

    @Override
    public boolean dropObjects(List<OWLObject> objects) {
        return false;
    }

    public String getTooltip() {
        if (this.ontology != null) {
            UIHelper helper = new UIHelper(this.owlEditorKit);
            StringBuffer buffer = new StringBuffer("<html>\n\t<body>\n\t\tAsserted in: ");
            buffer.append(helper.getHTMLOntologyList(Collections.singleton(this.ontology)));
            Set annotations = this.getAxiom().getAnnotations();
            if (annotations != null && !annotations.isEmpty()) {
                OWLModelManager protegeManager = this.getOWLModelManager();
                buffer.append("\n\t\t<p>Annotations:");
                buffer.append("\n\t\t<dl>");
                for (OWLAnnotation annotation : annotations) {
                    buffer.append("\n\t\t\t<dt>");
                    buffer.append(protegeManager.getRendering((OWLObject)annotation.getProperty()));
                    buffer.append("</dt>\n\t\t\t<dd>");
                    buffer.append(protegeManager.getRendering((OWLObject)annotation.getValue()));
                    buffer.append("</dd>");
                }
                buffer.append("\n\t\t</dl>\n\t</p>\n");
            }
            buffer.append("\t</body>\n</html>");
            return buffer.toString();
        }
        return "Inferred";
    }

    public String toString() {
        return this.getRendering();
    }

    @Override
    public List<? extends OWLOntologyChange> getDeletionChanges() {
        if (this.isDeleteable()) {
            return Arrays.asList(new RemoveAxiom(this.getOntology(), this.getAxiom()));
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isEditable() {
        return this.getOntology() != null;
    }

    public String getPrefix() {
        return "";
    }

    public String getDelimeter() {
        return DEFAULT_DELIMETER;
    }

    public String getSuffix() {
        return "";
    }

    protected Object getObjectRendering(OWLObject ob) {
        return this.getOWLModelManager().getRendering(ob);
    }

    @Override
    public boolean isInferred() {
        return this.ontology == null;
    }

    public String getRendering() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPrefix());
        Iterator<OWLObject> it = this.getManipulatableObjects().iterator();
        while (it.hasNext()) {
            OWLObject obj = it.next();
            sb.append(this.getObjectRendering(obj));
            if (!it.hasNext()) continue;
            sb.append(this.getDelimeter());
        }
        sb.append(this.getSuffix());
        return sb.toString();
    }

    @Override
    public boolean isDeleteable() {
        return this.isEditable();
    }

    public void handleEdit() {
    }

    public boolean handleDelete() {
        return false;
    }

    public List<MListButton> getAdditionalButtons() {
        return Collections.emptyList();
    }
}

