/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame.individual;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.protege.editor.owl.ui.editor.OWLDataPropertyRelationshipEditor;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLDataPropertyConstantPair;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.individual.OWLDataPropertyAssertionAxiomFrameSectionRow;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;

public class OWLDataPropertyAssertionAxiomFrameSection
extends AbstractOWLFrameSection<OWLIndividual, OWLDataPropertyAssertionAxiom, OWLDataPropertyConstantPair> {
    public static final String LABEL = "Data property assertions";
    private OWLDataPropertyRelationshipEditor editor;
    private Set<OWLDataPropertyAssertionAxiom> added = new HashSet<OWLDataPropertyAssertionAxiom>();

    @Override
    protected void clear() {
        if (this.editor != null) {
            this.editor.clear();
        }
    }

    public OWLDataPropertyAssertionAxiomFrameSection(OWLEditorKit editorKit, OWLFrame<? extends OWLIndividual> frame) {
        super(editorKit, LABEL, "Data property assertion", frame);
    }

    @Override
    protected void refill(OWLOntology ontology) {
        this.added.clear();
        for (OWLDataPropertyAssertionAxiom ax : ontology.getDataPropertyAssertionAxioms((OWLIndividual)this.getRootObject())) {
            this.addRow(new OWLDataPropertyAssertionAxiomFrameSectionRow(this.getOWLEditorKit(), this, ontology, (OWLIndividual)this.getRootObject(), ax));
            this.added.add(ax);
        }
    }

    @Override
    protected void refillInferred() {
        this.getOWLModelManager().getReasonerPreferences().executeTask(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_DATA_PROPERTY_ASSERTIONS, new Runnable(){

            @Override
            public void run() {
                if (!OWLDataPropertyAssertionAxiomFrameSection.this.getOWLModelManager().getReasoner().isConsistent()) {
                    return;
                }
                if (!((OWLIndividual)OWLDataPropertyAssertionAxiomFrameSection.this.getRootObject()).isAnonymous()) {
                    for (OWLDataProperty dp : OWLDataPropertyAssertionAxiomFrameSection.this.getReasoner().getRootOntology().getDataPropertiesInSignature(true)) {
                        Set values = OWLDataPropertyAssertionAxiomFrameSection.this.getReasoner().getDataPropertyValues(((OWLIndividual)OWLDataPropertyAssertionAxiomFrameSection.this.getRootObject()).asOWLNamedIndividual(), dp);
                        for (OWLLiteral constant : values) {
                            OWLDataPropertyAssertionAxiom ax = OWLDataPropertyAssertionAxiomFrameSection.this.getOWLDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dp, (OWLIndividual)OWLDataPropertyAssertionAxiomFrameSection.this.getRootObject(), constant);
                            if (OWLDataPropertyAssertionAxiomFrameSection.this.added.contains(ax)) continue;
                            OWLDataPropertyAssertionAxiomFrameSection.this.addRow(new OWLDataPropertyAssertionAxiomFrameSectionRow(OWLDataPropertyAssertionAxiomFrameSection.this.getOWLEditorKit(), OWLDataPropertyAssertionAxiomFrameSection.this, null, (OWLIndividual)OWLDataPropertyAssertionAxiomFrameSection.this.getRootObject(), ax));
                        }
                    }
                }
            }
        });
    }

    @Override
    protected OWLDataPropertyAssertionAxiom createAxiom(OWLDataPropertyConstantPair object) {
        return this.getOWLDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)object.getProperty(), (OWLIndividual)this.getRootObject(), object.getConstant());
    }

    @Override
    public OWLObjectEditor<OWLDataPropertyConstantPair> getObjectEditor() {
        if (this.editor == null) {
            this.editor = new OWLDataPropertyRelationshipEditor(this.getOWLEditorKit());
        }
        return this.editor;
    }

    @Override
    public Comparator<OWLFrameSectionRow<OWLIndividual, OWLDataPropertyAssertionAxiom, OWLDataPropertyConstantPair>> getRowComparator() {
        return null;
    }

    @Override
    protected boolean isResettingChange(OWLOntologyChange change) {
        return change.isAxiomChange() && change.getAxiom() instanceof OWLDataPropertyAssertionAxiom && ((OWLDataPropertyAssertionAxiom)change.getAxiom()).getSubject().equals(this.getRootObject());
    }
}

