/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.framelist;

import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.protege.editor.core.ui.list.RendererWithInsets;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.OWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.renderer.InlineAnnotationRendering;
import org.protege.editor.owl.ui.renderer.InlineDatatypeRendering;
import org.protege.editor.owl.ui.renderer.OWLAnnotationCellRenderer2;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;

public class OWLFrameListRenderer
implements ListCellRenderer,
RendererWithInsets {
    private OWLEditorKit owlEditorKit;
    private OWLCellRenderer owlCellRenderer;
    private ListCellRenderer separatorRenderer;
    private OWLAnnotationCellRenderer2 annotationRenderer;
    private boolean highlightKeywords;
    private boolean highlightUnsatisfiableClasses;
    private boolean highlightUnsatisfiableProperties;
    private Set<OWLEntity> crossedOutEntities;
    private boolean annotationRendererEnabled;

    public OWLFrameListRenderer(OWLEditorKit owlEditorKit) {
        this.owlEditorKit = owlEditorKit;
        this.owlCellRenderer = new OWLCellRenderer(owlEditorKit);
        this.separatorRenderer = new DefaultListCellRenderer();
        this.annotationRenderer = new OWLAnnotationCellRenderer2(owlEditorKit);
        this.highlightKeywords = true;
        this.highlightUnsatisfiableClasses = true;
        this.highlightUnsatisfiableProperties = true;
        this.annotationRendererEnabled = true;
        this.crossedOutEntities = new HashSet<OWLEntity>();
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.owlEditorKit;
    }

    public void setHighlightKeywords(boolean highlightKeywords) {
        this.highlightKeywords = highlightKeywords;
    }

    public void setAnnotationRendererEnabled(boolean enabled) {
        this.annotationRendererEnabled = enabled;
    }

    public OWLCellRenderer getOWLCellRenderer() {
        return this.owlCellRenderer;
    }

    public void setHighlightUnsatisfiableClasses(boolean b) {
        this.highlightUnsatisfiableClasses = b;
    }

    public boolean isHighlightUnsatisfiableClasses() {
        return this.highlightUnsatisfiableClasses;
    }

    public boolean isHighlightUnsatisfiableProperties() {
        return this.highlightUnsatisfiableProperties;
    }

    public void setHighlightUnsatisfiableProperties(boolean highlightUnsatisfiableProperties) {
        this.highlightUnsatisfiableProperties = highlightUnsatisfiableProperties;
    }

    public void setCrossedOutEntities(Set<OWLEntity> entities) {
        this.crossedOutEntities.clear();
        this.crossedOutEntities.addAll(entities);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof OWLFrameSection) {
            JLabel label = (JLabel)this.separatorRenderer.getListCellRendererComponent(list, " ", index, isSelected, cellHasFocus);
            label.setVerticalAlignment(1);
            return label;
        }
        AbstractOWLFrameSectionRow row = (AbstractOWLFrameSectionRow)value;
        Object axiom = row.getAxiom();
        if (axiom instanceof OWLAnnotationAssertionAxiom && this.annotationRendererEnabled) {
            OWLAnnotationAssertionAxiom annotationAssertionAxiom = (OWLAnnotationAssertionAxiom)axiom;
            this.annotationRenderer.setReferenceOntology(row.getOntology());
            this.annotationRenderer.setInlineAnnotationRendering(this.getRenderAnnotationAnnotationsInline());
            this.annotationRenderer.setInlineDatatypeRendering(this.getAnnotationLiteralDatatypeRendering());
            return this.annotationRenderer.getListCellRendererComponent(list, annotationAssertionAxiom, index, isSelected, cellHasFocus);
        }
        boolean commentedOut = false;
        this.owlCellRenderer.setCommentedOut(commentedOut);
        Object valueToRender = this.getValueToRender(list, value, index, isSelected, cellHasFocus);
        this.owlCellRenderer.setIconObject(this.getIconObject(list, value, index, isSelected, cellHasFocus));
        this.owlCellRenderer.setOntology(((OWLFrameSectionRow)value).getOntology());
        this.owlCellRenderer.setInferred(((OWLFrameSectionRow)value).isInferred());
        this.owlCellRenderer.setHighlightKeywords(this.highlightKeywords);
        this.owlCellRenderer.setHighlightUnsatisfiableClasses(this.highlightUnsatisfiableClasses);
        this.owlCellRenderer.setCrossedOutEntities(this.crossedOutEntities);
        return this.owlCellRenderer.getListCellRendererComponent(list, valueToRender, index, isSelected, cellHasFocus);
    }

    private InlineDatatypeRendering getAnnotationLiteralDatatypeRendering() {
        return OWLRendererPreferences.getInstance().isDisplayLiteralDatatypesInline() ? InlineDatatypeRendering.RENDER_DATATYPE_INLINE : InlineDatatypeRendering.DO_NOT_RENDER_DATATYPE_INLINE;
    }

    private InlineAnnotationRendering getRenderAnnotationAnnotationsInline() {
        return OWLRendererPreferences.getInstance().isDisplayAnnotationAnnotationsInline() ? InlineAnnotationRendering.RENDER_COMPOUND_ANNOTATIONS_INLINE : InlineAnnotationRendering.DO_NOT_RENDER_COMPOUND_ANNOTATIONS_INLINE;
    }

    public void setWrap(boolean b) {
        this.owlCellRenderer.setWrap(b);
    }

    protected OWLObject getIconObject(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        OWLObject firstObject;
        AbstractOWLFrameSectionRow row;
        if (value instanceof AbstractOWLFrameSectionRow && !(row = (AbstractOWLFrameSectionRow)value).getManipulatableObjects().isEmpty() && (firstObject = row.getManipulatableObjects().iterator().next()) instanceof OWLObject) {
            return firstObject;
        }
        return null;
    }

    protected Object getValueToRender(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof AbstractOWLFrameSectionRow) {
            value = ((AbstractOWLFrameSectionRow)value).getRendering();
        }
        return value;
    }
}

