/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.inference;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.protege.editor.owl.ui.inference.PrecomputePreferencesTableModel;
import org.protege.editor.owl.ui.preferences.OWLPreferencesPanel;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.slf4j.LoggerFactory;

public class PrecomputePreferencesPanel
extends OWLPreferencesPanel {
    private static final long serialVersionUID = -8812068573828834020L;
    private Set<InferenceType> required;
    private Set<InferenceType> disallowed;
    private Map<InferenceType, JCheckBox> selectedInferences = new EnumMap<InferenceType, JCheckBox>(InferenceType.class);

    public void initialise() throws Exception {
        this.readPreferences();
        this.setLayout(new BorderLayout());
        this.add(this.createCenterPanel(), "Center");
    }

    public void dispose() throws Exception {
    }

    private void readPreferences() {
        ReasonerPreferences preferences = this.getOWLModelManager().getOWLReasonerManager().getReasonerPreferences();
        this.required = EnumSet.noneOf(InferenceType.class);
        this.required.addAll(preferences.getRequired());
        this.disallowed = EnumSet.noneOf(InferenceType.class);
        this.disallowed.addAll(preferences.getDisallowed());
    }

    public void applyChanges() {
        ReasonerPreferences preferences = this.getOWLModelManager().getOWLReasonerManager().getReasonerPreferences();
        for (InferenceType type : InferenceType.values()) {
            preferences.setRequired(type, this.required.contains(type));
            preferences.setDisallowed(type, this.disallowed.contains(type));
        }
        preferences.save();
    }

    private JPanel createCenterPanel() {
        JPanel center = new JPanel();
        center.setLayout(new BoxLayout(center, 3));
        JComponent help = PrecomputePreferencesPanel.buildHelp("/PrecomputePreferencesHelp.txt");
        if (help != null) {
            center.add(help);
        }
        center.add(Box.createRigidArea(new Dimension(0, 10)));
        Box resetButtonContainer = new Box(0);
        resetButtonContainer.add(Box.createHorizontalGlue());
        JButton reset = new JButton("Reset to Default");
        reset.setAlignmentX(0.5f);
        resetButtonContainer.add(reset);
        resetButtonContainer.add(Box.createHorizontalGlue());
        center.add(resetButtonContainer);
        center.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel tableContainer = new JPanel(new BorderLayout());
        final PrecomputePreferencesTableModel tableModel = new PrecomputePreferencesTableModel(this.required, this.disallowed);
        JTable table = new JTable(tableModel);
        tableContainer.add((Component)table.getTableHeader(), "First");
        tableContainer.add((Component)table, "Center");
        double preferredWidth = 0.0;
        for (InferenceType type : InferenceType.values()) {
            double width = new JLabel(PrecomputePreferencesPanel.getInferenceTypeName(type)).getPreferredSize().getWidth();
            if (!(width > preferredWidth)) continue;
            preferredWidth = width;
        }
        table.getColumnModel().getColumn(PrecomputePreferencesTableModel.Column.INFERENCE_TYPE.ordinal()).setPreferredWidth((int)preferredWidth);
        table.getColumnModel().getColumn(PrecomputePreferencesTableModel.Column.REQUIRED.ordinal()).setPreferredWidth((int)new JLabel(PrecomputePreferencesTableModel.Column.REQUIRED.getColumnName()).getPreferredSize().getWidth());
        table.getColumnModel().getColumn(PrecomputePreferencesTableModel.Column.DISALLOWED.ordinal()).setPreferredWidth((int)new JLabel(PrecomputePreferencesTableModel.Column.DISALLOWED.getColumnName()).getPreferredSize().getWidth());
        reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrecomputePreferencesPanel.this.disallowed.clear();
                PrecomputePreferencesPanel.this.required.clear();
                tableModel.fireTableDataChanged();
            }
        });
        center.add(tableContainer);
        return center;
    }

    static JComponent buildHelp(String resource) {
        Box help = new Box(1);
        help.setAlignmentX(0.0f);
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(PrecomputePreferencesPanel.class.getResourceAsStream(resource)));
            while ((line = reader.readLine()) != null) {
                help.add(new JLabel(line));
            }
            return help;
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(PrecomputePreferencesPanel.class).error("Error building PrecomputePreferencesPanel help for resource: {}", (Object)resource);
            return null;
        }
    }

    public Set<InferenceType> getPreCompute() {
        EnumSet<InferenceType> preCompute = EnumSet.noneOf(InferenceType.class);
        for (Map.Entry<InferenceType, JCheckBox> entry : this.selectedInferences.entrySet()) {
            JCheckBox check = entry.getValue();
            if (!check.isSelected()) continue;
            preCompute.add(entry.getKey());
        }
        return preCompute;
    }

    public static String getInferenceTypeName(InferenceType type) {
        return type.toString();
    }
}

