/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.metrics;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.owl.ui.OWLIcons;

public class DLNameKeyPanel
extends JPanel {
    public DLNameKeyPanel() {
        ArrayList<NameObject> box = new ArrayList<NameObject>();
        this.addExplanation(OWLIcons.getIcon("AL.png"), "Attributive language.  This is the base language which allows:<ul><li>Atomic negation (negation of concepts that do not appear on the left hand side of axioms)</li><li>Concept intersection</li><li>Universal restrictions</li><li>Limited existential quantification (restrictions that only have fillers of Thing)</li></ul>", box);
        this.addExplanation(OWLIcons.getIcon("FLM.png"), "A sub-language of AL, which is obtained by disallowing atomic negation", box);
        this.addExplanation(OWLIcons.getIcon("FLO.png"), "A sub-language of FL<sup>-</sup>, which is obtained by disallowing limited existential quantification", box);
        this.addExplanation(OWLIcons.getIcon("C.png"), "Complex concept negation", box);
        this.addExplanation(OWLIcons.getIcon("S.png"), "An abbreviation for AL and C with transitive properties", box);
        this.addExplanation(OWLIcons.getIcon("H.png"), "Role hierarchy (subproperties - rdfs:subPropertyOf)", box);
        this.addExplanation(OWLIcons.getIcon("O.png"), "Nominals. (Enumerated classes or object value restrictions - owl:oneOf, owl:hasValue)", box);
        this.addExplanation(OWLIcons.getIcon("I.png"), "Inverse properties", box);
        this.addExplanation(OWLIcons.getIcon("N.png"), "Cardinality restrictions (owl:Cardinality, owl:minCardianlity, owl:maxCardinality)", box);
        this.addExplanation(OWLIcons.getIcon("Q.png"), "Qualified cardinality restrictions (available in OWL 1.1)", box);
        this.addExplanation(OWLIcons.getIcon("F.png"), "Functional properties", box);
        this.addExplanation(OWLIcons.getIcon("E.png"), "Full existential quantification (Existential restrictions that have fillers other that owl:Thing)", box);
        this.addExplanation(OWLIcons.getIcon("U.png"), "Concept union", box);
        this.addExplanation(OWLIcons.getIcon("Datatype.png"), "Use of datatype properties, data values or datatypes", box);
        this.setLayout(new BorderLayout());
        JList<Object> l = new JList<Object>(box.toArray());
        l.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                NameObject nameObject = (NameObject)value;
                label.setIcon(nameObject.getIcon());
                label.setText(nameObject.getDesc());
                label.setFont(new Font(label.getFont().getName(), 0, 12));
                label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(5, 2, 5, 2)));
                return label;
            }
        });
        l.setBackground(Color.WHITE);
        JScrollPane sp = ComponentFactory.createScrollPane(l);
        this.add((Component)sp, "Center");
    }

    private void addExplanation(Icon icon, String description, List<NameObject> list) {
        list.add(new NameObject(icon, description));
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setContentPane(new DLNameKeyPanel());
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }

    private class NameObject {
        private Icon icon;
        private String desc;

        public NameObject(final Icon icon, String desc) {
            this.icon = new Icon(){

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    icon.paintIcon(c, g, x, y);
                }

                @Override
                public int getIconWidth() {
                    return 80;
                }

                @Override
                public int getIconHeight() {
                    return icon.getIconHeight();
                }
            };
            this.desc = "<html><body>" + desc + "</body></html>";
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

