/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.protege.editor.core.ProtegeManager;
import org.protege.editor.core.ui.util.JOptionPaneEx;
import org.protege.editor.core.ui.workspace.Workspace;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLWorkspace;
import org.protege.editor.owl.model.io.OntologySourcesListener;
import org.protege.editor.owl.model.io.OntologySourcesManager;
import org.protege.editor.owl.ui.selector.OWLOntologySelectorPanel2;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;

public class OntologySourcesChangedHandlerUI
implements OntologySourcesListener {
    private OWLEditorKit eKit;
    private static final String TITLE = "Ontology sources changed";
    private boolean handlingChange = false;
    private OWLOntologySelectorPanel2 ontologiesPanel;

    public OntologySourcesChangedHandlerUI(final OWLWorkspace workspace) {
        this.eKit = workspace.getOWLEditorKit();
        this.getSourcesManager().addListener(this);
        workspace.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                ProtegeManager.getInstance().getFrame((Workspace)workspace).addWindowListener((WindowListener)new WindowAdapter(){

                    @Override
                    public void windowActivated(WindowEvent event) {
                        OntologySourcesChangedHandlerUI.this.handleWindowActivated();
                    }
                });
                workspace.removeAncestorListener(this);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    @Override
    public void ontologySourcesChanged(OntologySourcesListener.OntologySourcesChangeEvent event) {
        this.handlingChange = true;
        Set<OWLOntology> onts = event.getOntologies();
        if (onts.size() == 1) {
            OWLOntology ont = onts.iterator().next();
            StringBuilder message = new StringBuilder("<html>An ontology has changed outside of Protege.");
            message.append("<p><p><code>").append(this.eKit.getModelManager().getRendering((OWLObject)ont)).append("</code>");
            message.append("<p><p>Would you like to reload?");
            if (this.eKit.getModelManager().getDirtyOntologies().contains(ont)) {
                message.append("<p><p><b>Warning: this ontology has been edited so you will lose local changes</b>");
            }
            message.append("</html>");
            if (JOptionPane.showConfirmDialog((Component)((Object)this.eKit.getWorkspace()), message.toString(), TITLE, 0, 2) == 0) {
                try {
                    this.eKit.getModelManager().reload(ont);
                }
                catch (OWLOntologyCreationException e) {
                    this.handleFailedToReload(ont);
                }
            } else {
                this.getSourcesManager().ignoreUpdates(onts);
            }
        } else {
            this.ontologiesPanel = new OWLOntologySelectorPanel2(this.eKit, onts);
            this.ontologiesPanel.add((Component)new JLabel("<html>The following ontologies have changed outside of Protege.<p><p>Would you like to reload?</html>"), "North");
            HashSet<OWLOntology> ignoreOnts = new HashSet<OWLOntology>(onts);
            if (JOptionPaneEx.showConfirmDialog((Component)((Object)this.eKit.getWorkspace()), (String)TITLE, (JComponent)this.ontologiesPanel, (int)2, (int)0, null) == 0) {
                Set<OWLOntology> reloadOnts = this.getFilteredValues();
                ignoreOnts.removeAll(reloadOnts);
                for (OWLOntology ont : reloadOnts) {
                    try {
                        this.eKit.getModelManager().reload(ont);
                    }
                    catch (OWLOntologyCreationException e) {
                        this.handleFailedToReload(ont);
                    }
                }
            }
            if (!ignoreOnts.isEmpty()) {
                this.getSourcesManager().ignoreUpdates(ignoreOnts);
            }
        }
        this.handlingChange = false;
    }

    private Set<OWLOntology> getFilteredValues() {
        return this.ontologiesPanel.getSelectedOntologies();
    }

    private void handleFailedToReload(OWLOntology ont) {
        JOptionPane.showMessageDialog((Component)((Object)this.eKit.getWorkspace()), "<html>Failed to reload ontology<p><p>" + this.eKit.getModelManager().getRendering((OWLObject)ont) + ".<p><p>Ignoring update.</html>");
        this.getSourcesManager().ignoreUpdates(Collections.singleton(ont));
    }

    protected void handleWindowActivated() {
        OntologySourcesManager sourcesMngr;
        if (!this.handlingChange && (sourcesMngr = this.getSourcesManager()) != null) {
            sourcesMngr.checkSources();
        }
    }

    private OntologySourcesManager getSourcesManager() {
        return (OntologySourcesManager)this.eKit.getModelManager().get(OntologySourcesManager.ID);
    }
}

