/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.imports;

import com.google.common.base.Optional;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;
import org.protege.editor.core.ui.list.MListButton;
import org.protege.editor.core.ui.list.MListItem;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.RemoveImport;

class OntologyImportItem
implements MListItem {
    private OWLOntology ont;
    private OWLImportsDeclaration decl;
    private OWLEditorKit eKit;
    private MListButton fixImportsButton = new FixImportsButton(new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            OntologyImportItem.this.handleImportsFix();
        }
    });

    public OntologyImportItem(OWLOntology ont, OWLImportsDeclaration decl, OWLEditorKit eKit) {
        this.ont = ont;
        this.decl = decl;
        this.eKit = eKit;
    }

    public List<MListButton> getAdditionalButtons() {
        OWLOntology ont = this.eKit.getOWLModelManager().getOWLOntologyManager().getImportedOntology(this.decl);
        if (ont == null) {
            return Collections.emptyList();
        }
        Optional defaultDocumentIRI = ont.getOntologyID().getDefaultDocumentIRI();
        if (Optional.of((Object)this.decl.getIRI()).equals((Object)defaultDocumentIRI)) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.fixImportsButton);
    }

    private void handleImportsFix() {
        int ret = JOptionPane.showConfirmDialog((Component)((Object)this.eKit.getWorkspace()), this.getMismatchedImportMessage(), "Mismatched import", 0, 2);
        if (ret == 0) {
            Optional defaultDocumentIRI;
            ArrayList<Object> changes = new ArrayList<Object>();
            changes.add(new RemoveImport(this.ont, this.decl));
            OWLModelManager mngr = this.eKit.getOWLModelManager();
            OWLOntology impOnt = mngr.getOWLOntologyManager().getImportedOntology(this.decl);
            if (impOnt != null && (defaultDocumentIRI = impOnt.getOntologyID().getDefaultDocumentIRI()).isPresent()) {
                changes.add(new AddImport(this.ont, mngr.getOWLDataFactory().getOWLImportsDeclaration((IRI)defaultDocumentIRI.get())));
                mngr.applyChanges(changes);
            }
        }
    }

    private String getMismatchedImportMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body>");
        sb.append("The imports URI:<br>");
        sb.append("<font color=\"blue\">");
        sb.append((CharSequence)this.decl.getIRI());
        sb.append("</font>");
        sb.append("<br>");
        sb.append("does not match the URI of the ontology that has been imported:<br>");
        sb.append("<font color=\"blue\">");
        OWLOntology ont = this.eKit.getOWLModelManager().getOWLOntologyManager().getImportedOntology(this.decl);
        sb.append(ont == null ? "(Not loaded)" : (CharSequence)ont.getOntologyID().getDefaultDocumentIRI().get());
        sb.append("</font><br><br>");
        sb.append("Do you want to fix the mismatch by modifying the imports statement?");
        sb.append("</body></html>");
        return sb.toString();
    }

    public boolean isEditable() {
        return false;
    }

    public void handleEdit() {
    }

    public boolean isDeleteable() {
        return true;
    }

    public boolean handleDelete() {
        this.eKit.getModelManager().applyChange((OWLOntologyChange)new RemoveImport(this.ont, this.decl));
        return true;
    }

    public String getTooltip() {
        return "";
    }

    public OWLImportsDeclaration getImportDeclaration() {
        return this.decl;
    }

    private class FixImportsButton
    extends MListButton {
        public FixImportsButton(ActionListener actionListener) {
            super("Mismatched import!", Color.ORANGE, actionListener);
        }

        public void paintButtonContent(Graphics2D g) {
            Rectangle bounds = this.getBounds();
            g.translate(bounds.x, bounds.y - 1);
            g.drawLine(bounds.width / 2, 4, 4, bounds.height - 4);
            g.drawLine(bounds.width / 2, 4, bounds.width - 4, bounds.height - 4);
            g.drawLine(4, bounds.height - 4, bounds.width - 4, bounds.height - 4);
            g.translate(-bounds.x, -bounds.y + 1);
        }

        public Color getBackground() {
            return Color.ORANGE;
        }
    }
}

