/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.imports.wizard.page;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.list.OWLObjectList;
import org.protege.editor.owl.ui.ontology.imports.wizard.ImportInfo;
import org.protege.editor.owl.ui.ontology.imports.wizard.OntologyImportWizard;
import org.protege.editor.owl.ui.ontology.imports.wizard.page.ImportConfirmationPage;
import org.protege.editor.owl.ui.ontology.imports.wizard.page.OntologyImportPage;
import org.protege.editor.owl.ui.ontology.imports.wizard.page.SelectImportLocationPage;
import org.protege.editor.owl.ui.renderer.OWLOntologyCellRenderer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class LoadedOntologyPage
extends OntologyImportPage {
    private static final long serialVersionUID = 7719702648603699776L;
    public static final String ID = LoadedOntologyPage.class.getName();
    private JList ontologyList;

    public LoadedOntologyPage(OWLEditorKit owlEditorKit) {
        super(ID, "Import pre-loaded ontology", owlEditorKit);
    }

    private List<OWLOntology> getOntologies() {
        OWLModelManager mngr = this.getOWLModelManager();
        ArrayList<OWLOntology> ontologies = new ArrayList<OWLOntology>(mngr.getOntologies());
        ontologies.removeAll(mngr.getOWLOntologyManager().getImportsClosure(mngr.getActiveOntology()));
        ontologies.removeAll(this.getOntologiesInSeries(mngr.getActiveOntology(), ontologies));
        Collections.sort(ontologies, mngr.getOWLObjectComparator());
        return ontologies;
    }

    private Set<OWLOntology> getOntologiesInSeries(OWLOntology ontology, Collection<OWLOntology> ontologies) {
        HashSet<OWLOntology> ontologiesInSeries = new HashSet<OWLOntology>();
        if (!ontology.getOntologyID().isAnonymous()) {
            for (OWLOntology ont : ontologies) {
                if (ont.getOntologyID().isAnonymous() || !ont.getOntologyID().getOntologyIRI().equals((Object)ontology.getOntologyID().getOntologyIRI())) continue;
                ontologiesInSeries.add(ont);
            }
        }
        return ontologiesInSeries;
    }

    public void aboutToHidePanel() {
        OntologyImportWizard wizard = this.getWizard();
        wizard.setImportsAreFinal(false);
        wizard.clearImports();
        for (Object o : this.ontologyList.getSelectedValues()) {
            OWLOntology ontology = (OWLOntology)o;
            OWLOntologyID id = ontology.getOntologyID();
            IRI physicalLocation = this.getOWLModelManager().getOWLOntologyManager().getOntologyDocumentIRI(ontology);
            ImportInfo parameter = new ImportInfo();
            parameter.setOntologyID(ontology.getOntologyID());
            parameter.setPhysicalLocation(physicalLocation.toURI());
            parameter.setImportLocation(!id.isAnonymous() ? (IRI)id.getDefaultDocumentIRI().get() : physicalLocation);
            wizard.addImport(parameter);
        }
        ((SelectImportLocationPage)this.getWizardModel().getPanel((Object)"SelectImportLocationPage")).setBackPanelDescriptor(ID);
        ((ImportConfirmationPage)this.getWizardModel().getPanel((Object)"ImportConfirmationPage")).setBackPanelDescriptor(ID);
        super.aboutToHidePanel();
    }

    protected void createUI(JComponent parent) {
        this.setInstructions("Please select an existing (pre-loaded) ontology that you want to import.");
        this.ontologyList = new OWLObjectList(this.getOWLEditorKit());
        this.ontologyList.setCellRenderer(new OWLOntologyCellRenderer(this.getOWLEditorKit()));
        this.ontologyList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    LoadedOntologyPage.this.updateState();
                }
            }
        });
        parent.setLayout(new BorderLayout());
        parent.add((Component)ComponentFactory.createScrollPane((JComponent)this.ontologyList), "Center");
        parent.add((Component)this.createCustomizedImportsComponent(), "South");
    }

    private void fillList() {
        this.ontologyList.setListData(this.getOntologies().toArray());
    }

    public Object getNextPanelDescriptor() {
        return this.getWizard().isCustomizeImports() ? "SelectImportLocationPage" : "ImportConfirmationPage";
    }

    public Object getBackPanelDescriptor() {
        return "ImportTypePage";
    }

    public void displayingPanel() {
        this.fillList();
        this.updateState();
        this.ontologyList.requestFocus();
    }

    private void updateState() {
        this.getWizard().setNextFinishButtonEnabled(this.ontologyList.getSelectedValue() != null);
    }
}

