/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.imports.wizard.page;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.net.URI;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.protege.editor.core.editorkit.EditorKitDescriptor;
import org.protege.editor.core.editorkit.RecentEditorKitManager;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.core.ui.util.FilePathPanel;
import org.protege.editor.core.ui.util.UIUtil;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.ontology.imports.wizard.ImportInfo;
import org.protege.editor.owl.ui.ontology.imports.wizard.OntologyImportWizard;
import org.protege.editor.owl.ui.ontology.imports.wizard.page.ImportConfirmationPage;
import org.protege.editor.owl.ui.ontology.imports.wizard.page.OntologyImportPage;
import org.protege.editor.owl.ui.ontology.imports.wizard.page.SelectImportLocationPage;

public class LocalFilePage
extends OntologyImportPage {
    private static final long serialVersionUID = 8587705447779952633L;
    public static final String ID = "LocalFilePage";
    private FilePathPanel filePathPanel;

    public LocalFilePage(OWLEditorKit owlEditorKit) {
        super(ID, "Import from local file", owlEditorKit);
    }

    protected void createUI(JComponent parent) {
        this.setInstructions("Please specify the path to a file that contains an ontology.  You can use the browse button to show a file chooser dialog.");
        this.filePathPanel = new FilePathPanel("Please select a file", UIHelper.OWL_EXTENSIONS);
        this.filePathPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LocalFilePage.this.updateFinishEnabled();
            }
        });
        this.filePathPanel.setBorder(ComponentFactory.createTitledBorder((String)"Path"));
        JList recentList = this.createRecentList();
        JPanel recentListHolder = new JPanel(new BorderLayout());
        recentListHolder.setBorder(ComponentFactory.createTitledBorder((String)"Recent locations"));
        recentListHolder.add((Component)new JScrollPane(recentList), "Center");
        parent.setLayout(new BorderLayout(6, 6));
        parent.add((Component)this.filePathPanel, "North");
        parent.add((Component)recentListHolder, "Center");
        parent.add((Component)this.createCustomizedImportsComponent(), "South");
    }

    @Override
    public void aboutToDisplayPanel() {
        this.updateFinishEnabled();
        super.aboutToDisplayPanel();
    }

    public void aboutToHidePanel() {
        OntologyImportWizard wizard = this.getWizard();
        wizard.setImportsAreFinal(false);
        wizard.clearImports();
        ImportInfo parameters = new ImportInfo();
        parameters.setPhysicalLocation(this.filePathPanel.getFile().toURI());
        wizard.addImport(parameters);
        ((SelectImportLocationPage)this.getWizardModel().getPanel((Object)"SelectImportLocationPage")).setBackPanelDescriptor(ID);
        ((ImportConfirmationPage)this.getWizardModel().getPanel((Object)"ImportConfirmationPage")).setBackPanelDescriptor(ID);
        super.aboutToHidePanel();
    }

    private void updateFinishEnabled() {
        File f = this.filePathPanel.getFile();
        this.getWizard().setNextFinishButtonEnabled(f.exists() && !f.isDirectory());
    }

    private JList createRecentList() {
        DefaultListModel<EditorKitDescriptor> model = new DefaultListModel<EditorKitDescriptor>();
        RecentEditorKitManager man = RecentEditorKitManager.getInstance();
        for (EditorKitDescriptor descriptor : man.getDescriptors()) {
            URI uri = descriptor.getURI("URI");
            if (uri.getScheme() == null || !UIUtil.isLocalFile((URI)uri)) continue;
            model.addElement(descriptor);
        }
        final JList list = new JList(model);
        list.setSelectionMode(0);
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                String path = ((EditorKitDescriptor)list.getSelectedValue()).getLabel();
                LocalFilePage.this.filePathPanel.setPath(path);
            }
        });
        return list;
    }

    public Object getBackPanelDescriptor() {
        return "ImportTypePage";
    }

    public Object getNextPanelDescriptor() {
        return "AnticipateOntologyIdPage";
    }

    public void displayingPanel() {
        this.getWizard().setNextFinishButtonEnabled(false);
        this.filePathPanel.requestFocus();
    }
}

