/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.wizard.move.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.protege.editor.core.ui.list.RemovableObjectList;
import org.protege.editor.core.ui.util.CheckList;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.owl.ui.list.OWLObjectList;
import org.protege.editor.owl.ui.ontology.wizard.move.MoveAxiomsKitConfigurationPanel;
import org.protege.editor.owl.ui.ontology.wizard.move.common.SignatureSelection;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;

public class SignatureDependentSelectionPreviewPanel
extends MoveAxiomsKitConfigurationPanel {
    private SignatureSelection signatureSelection;
    private OWLObjectList previewList;
    private JLabel previewLabel;
    private RemovableObjectList<OWLEntity> signatureList;
    private CheckList list;
    private Timer previewTimer;

    public SignatureDependentSelectionPreviewPanel(SignatureSelection signatureSelection) {
        this.signatureSelection = signatureSelection;
        this.previewLabel = new JLabel("Axioms: ");
    }

    @Override
    public void initialise() {
        this.setLayout(new BorderLayout(7, 7));
        JPanel previewPanel = new JPanel(new BorderLayout(3, 3));
        this.previewLabel = new JLabel("Axioms: Computing... ");
        previewPanel.add((Component)this.previewLabel, "North");
        this.previewList = new OWLObjectList(this.getEditorKit());
        previewPanel.add(new JScrollPane(this.previewList));
        previewPanel.setBorder(ComponentFactory.createTitledBorder((String)"Preview"));
        this.add(previewPanel);
        OWLCellRenderer cellRenderer = new OWLCellRenderer(this.getEditorKit());
        cellRenderer.setWrap(false);
        cellRenderer.setHighlightKeywords(true);
        this.previewList.setCellRenderer(cellRenderer);
        this.signatureList = new RemovableObjectList();
        this.signatureList.setCellRenderer((ListCellRenderer)cellRenderer);
        this.signatureList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    // empty if block
                }
            }
        });
        this.signatureList.setPreferredSize(new Dimension(300, 300));
        JPanel signatureListPanel = new JPanel(new BorderLayout());
        this.list = new CheckList(this.signatureList);
        this.list.addCheckListListener(new CheckList.CheckListListener(){

            public void itemChecked(Object item) {
                SignatureDependentSelectionPreviewPanel.this.updatePreview();
            }

            public void itemUnchecked(Object item) {
                SignatureDependentSelectionPreviewPanel.this.updatePreview();
            }
        });
        signatureListPanel.add(new JScrollPane((Component)this.list));
        signatureListPanel.setBorder(ComponentFactory.createTitledBorder((String)"Signature"));
        this.add((Component)signatureListPanel, "West");
        this.signatureList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                SignatureDependentSelectionPreviewPanel.this.updateSignature();
            }
        });
        this.previewTimer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SignatureDependentSelectionPreviewPanel.this.doPreviewUpdate();
            }
        });
        this.previewTimer.setRepeats(false);
    }

    public void updateSignature() {
        HashSet<OWLEntity> newSig;
        Set<OWLEntity> sig = this.signatureSelection.getSignature();
        if (!sig.equals(newSig = new HashSet<OWLEntity>(this.getCheckedEntities()))) {
            this.signatureSelection.setSignature(newSig);
            this.updatePreview();
        }
    }

    @Override
    public String getInstructions() {
        return "Confirm the signature";
    }

    public void updatePreview() {
        this.previewTimer.restart();
    }

    private void doPreviewUpdate() {
        this.previewLabel.setText("Axioms: Computing... ");
        this.previewLabel.repaint();
        this.previewList.setListData(new Object[0]);
        final Set<OWLEntity> entities = this.getCheckedEntities();
        final Set<OWLOntology> sourceOntologies = this.getModel().getSourceOntologies();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                final Set<OWLAxiom> axioms = SignatureDependentSelectionPreviewPanel.this.signatureSelection.getAxioms(sourceOntologies, entities);
                final ArrayList<OWLAxiom> axs = new ArrayList<OWLAxiom>(new TreeSet<OWLAxiom>(axioms));
                final int upperBound = 500 > axs.size() ? axs.size() : 500;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        SignatureDependentSelectionPreviewPanel.this.previewLabel.setText("Axioms (showing " + upperBound + " out of " + axioms.size() + " axioms)");
                    }
                };
                SwingUtilities.invokeLater(runnable);
                Runnable runnable2 = new Runnable(){

                    @Override
                    public void run() {
                        SignatureDependentSelectionPreviewPanel.this.previewList.setListData(axs.subList(0, upperBound).toArray());
                    }
                };
                SwingUtilities.invokeLater(runnable2);
            }
        };
        Thread t = new Thread(runnable);
        t.start();
    }

    private Set<OWLEntity> getCheckedEntities() {
        HashSet<OWLEntity> entities = new HashSet<OWLEntity>();
        for (Object o : this.list.getCheckedItems()) {
            RemovableObjectList.RemovableObjectListItem item = (RemovableObjectList.RemovableObjectListItem)o;
            entities.add((OWLEntity)item.getObject());
        }
        return entities;
    }

    @Override
    public void dispose() {
    }

    @Override
    public String getID() {
        return "modularity.selectlocalitytype";
    }

    @Override
    public String getTitle() {
        return "Module preview page";
    }

    @Override
    public void update() {
        Set<OWLEntity> sig = this.signatureSelection.getSignature();
        this.signatureList.setListData(sig.toArray());
        this.updatePreview();
    }

    @Override
    public void commit() {
        this.signatureSelection.setSignature(this.getCheckedEntities());
    }
}

