/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.core.ui.preferences.PreferencesLayoutPanel;
import org.protege.editor.owl.model.axiom.FreshAxiomLocation;
import org.protege.editor.owl.model.axiom.FreshAxiomLocationPreferences;
import org.protege.editor.owl.ui.clsdescriptioneditor.ExpressionEditorPreferences;
import org.protege.editor.owl.ui.preferences.OWLPreferencesPanel;
import org.protege.editor.owl.ui.tree.OWLTreePreferences;

public class GeneralPreferencesPanel
extends OWLPreferencesPanel {
    public static final String DIALOGS_ALWAYS_CENTRED = "DIALOGS_ALWAYS_CENTRED";
    private JSpinner checkDelaySpinner;
    private static final String SECOND_TOOL_TIP = "1000 = 1 second";
    private JCheckBox alwaysCentreDialogsCheckbox;
    private JCheckBox detachedWindowsFloat;
    private JRadioButton addFreshAxiomsToActiveOntologyRadioButton;
    private JRadioButton addFreshAxiomsToSubjectDefiningOntology;
    private JCheckBox autoExpandEnabledCheckBox;
    private JSpinner autoExpandMaxDepthSpinner;
    private JSpinner autoExpandMaxChildSizeSpinner;

    public void applyChanges() {
        ExpressionEditorPreferences.getInstance().setCheckDelay((Integer)this.checkDelaySpinner.getModel().getValue());
        Preferences appPrefs = PreferencesManager.getInstance().getApplicationPreferences("org.protege.editor.core.application");
        appPrefs.putBoolean(DIALOGS_ALWAYS_CENTRED, this.alwaysCentreDialogsCheckbox.isSelected());
        appPrefs.putBoolean("DETACHED_WINDOWS_FLOAT", this.detachedWindowsFloat.isSelected());
        FreshAxiomLocationPreferences axiomPrefs = FreshAxiomLocationPreferences.getPreferences();
        if (this.addFreshAxiomsToActiveOntologyRadioButton.isSelected()) {
            axiomPrefs.setFreshAxiomLocation(FreshAxiomLocation.ACTIVE_ONTOLOGY);
        } else if (this.addFreshAxiomsToSubjectDefiningOntology.isSelected()) {
            axiomPrefs.setFreshAxiomLocation(FreshAxiomLocation.SUBJECT_DEFINING_ONTOLOGY);
        }
        OWLTreePreferences prefs = OWLTreePreferences.getInstance();
        prefs.setAutoExpansionEnabled(this.autoExpandEnabledCheckBox.isSelected());
        prefs.setAutoExpansionDepthLimit((Integer)this.autoExpandMaxDepthSpinner.getValue());
        prefs.setAutoExpansionChildLimit((Integer)this.autoExpandMaxChildSizeSpinner.getValue());
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        PreferencesLayoutPanel panel = new PreferencesLayoutPanel();
        this.add((Component)panel, "North");
        panel.addGroup("Editor delay");
        int checkDelay = ExpressionEditorPreferences.getInstance().getCheckDelay();
        this.checkDelaySpinner = new JSpinner(new SpinnerNumberModel(checkDelay, 0, 10000, 50));
        this.checkDelaySpinner.setToolTipText(SECOND_TOOL_TIP);
        panel.addGroupComponent((JComponent)this.checkDelaySpinner);
        Preferences appPrefs = PreferencesManager.getInstance().getApplicationPreferences("org.protege.editor.core.application");
        this.alwaysCentreDialogsCheckbox = new JCheckBox("Centre dialogs on workspace");
        this.alwaysCentreDialogsCheckbox.setSelected(appPrefs.getBoolean(DIALOGS_ALWAYS_CENTRED, false));
        this.detachedWindowsFloat = new JCheckBox("Detached windows float");
        this.detachedWindowsFloat.setSelected(appPrefs.getBoolean("DETACHED_WINDOWS_FLOAT", true));
        panel.addSeparator();
        panel.addGroup("Windows");
        panel.addGroupComponent((JComponent)this.alwaysCentreDialogsCheckbox);
        panel.addGroupComponent((JComponent)this.detachedWindowsFloat);
        panel.addSeparator();
        ButtonGroup axiomButtonGroup = new ButtonGroup();
        this.addFreshAxiomsToActiveOntologyRadioButton = new JRadioButton("Add fresh axioms to active ontology", FreshAxiomLocationPreferences.getPreferences().getFreshAxiomLocation() == FreshAxiomLocation.ACTIVE_ONTOLOGY);
        this.addFreshAxiomsToSubjectDefiningOntology = new JRadioButton("Add fresh axioms to subject defining ontology", FreshAxiomLocationPreferences.getPreferences().getFreshAxiomLocation() == FreshAxiomLocation.SUBJECT_DEFINING_ONTOLOGY);
        this.addFreshAxiomsToSubjectDefiningOntology.setToolTipText("Adds fresh axioms to the ontology where their subject is defined.  If no such ontology exists then axioms are added to the active ontology.");
        axiomButtonGroup.add(this.addFreshAxiomsToActiveOntologyRadioButton);
        axiomButtonGroup.add(this.addFreshAxiomsToSubjectDefiningOntology);
        panel.addGroup("Axioms");
        panel.addGroupComponent((JComponent)this.addFreshAxiomsToActiveOntologyRadioButton);
        panel.addGroupComponent((JComponent)this.addFreshAxiomsToSubjectDefiningOntology);
        OWLTreePreferences prefs = OWLTreePreferences.getInstance();
        this.autoExpandEnabledCheckBox = new JCheckBox("Expand trees by default", prefs.isAutoExpandEnabled());
        this.autoExpandMaxDepthSpinner = new JSpinner(new SpinnerNumberModel(prefs.getAutoExpansionDepthLimit(), 1, Integer.MAX_VALUE, 1));
        this.autoExpandMaxChildSizeSpinner = new JSpinner(new SpinnerNumberModel(prefs.getAutoExpansionChildLimit(), 1, Integer.MAX_VALUE, 1));
        panel.addSeparator();
        panel.addGroup("");
        panel.addGroupComponent((JComponent)this.autoExpandEnabledCheckBox);
        panel.addGroup("Number of levels shown");
        panel.addGroupComponent((JComponent)this.autoExpandMaxDepthSpinner);
        panel.addGroup("Maximum child cut off");
        panel.addGroupComponent((JComponent)this.autoExpandMaxChildSizeSpinner);
    }

    public void initialise() throws Exception {
        this.createUI();
    }

    public void dispose() {
    }

    public static void main(String[] args) throws Exception {
        GeneralPreferencesPanel pp = new GeneralPreferencesPanel();
        pp.initialise();
        JDialog dlg = new JDialog();
        dlg.getContentPane().add((Component)((Object)pp));
        dlg.pack();
        dlg.setVisible(true);
    }
}

