/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import java.util.ArrayList;
import java.util.List;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.renderer.OWLEntityRendererListener;
import org.protege.editor.owl.ui.renderer.OWLModelManagerEntityRenderer;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;

public abstract class AbstractOWLEntityRenderer
implements OWLModelManagerEntityRenderer {
    private OWLModelManager mngr;
    private List<OWLEntityRendererListener> listeners = new ArrayList<OWLEntityRendererListener>();
    private OWLOntologyChangeListener l = new OWLOntologyChangeListener(){

        public void ontologiesChanged(List<? extends OWLOntologyChange> owlOntologyChanges) throws OWLException {
            AbstractOWLEntityRenderer.this.processChanges(owlOntologyChanges);
        }
    };

    @Override
    public void setup(OWLModelManager owlModelManager) {
        this.mngr = owlModelManager;
        this.mngr.addOntologyChangeListener(this.l);
    }

    @Override
    public void addListener(OWLEntityRendererListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(OWLEntityRendererListener listener) {
        this.listeners.remove(listener);
    }

    public final String getShortForm(OWLEntity owlEntity) {
        return this.render(owlEntity);
    }

    @Override
    public String render(OWLEntity owlEntity) {
        return this.render(owlEntity.getIRI());
    }

    protected void processChanges(List<? extends OWLOntologyChange> changes) {
    }

    protected OWLModelManager getOWLModelManager() {
        return this.mngr;
    }

    protected void fireRenderingChanged(OWLEntity entity) {
        for (OWLEntityRendererListener listener : new ArrayList<OWLEntityRendererListener>(this.listeners)) {
            listener.renderingChanged(entity, this);
        }
    }

    @Override
    public void ontologiesChanged() {
    }

    public final void dispose() {
        this.listeners.clear();
        this.mngr.removeOntologyChangeListener(this.l);
        this.disposeRenderer();
    }

    protected abstract void disposeRenderer();
}

