/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.Icon;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;

public abstract class OWLEntityIcon
implements Icon {
    private static int DEFAULT_PADDING_PX = 2;
    private SizeBias sizeBias;

    protected OWLEntityIcon(SizeBias sizeBias) {
        this.sizeBias = sizeBias;
    }

    protected int getSize() {
        int fontSize = OWLRendererPreferences.getInstance().getFontSize();
        int idealSize = fontSize + this.getPadding() * 2;
        int size = this.sizeBias.equals((Object)SizeBias.EVEN) ? idealSize / 2 * 2 : idealSize / 2 * 2 + 1;
        return size;
    }

    protected int getBaseline(Component c, int defaultBaseline) {
        if (c == null) {
            return defaultBaseline;
        }
        Font f = c.getFont();
        if (f == null) {
            return defaultBaseline;
        }
        FontMetrics fm = c.getFontMetrics(f);
        return fm.getAscent() + fm.getLeading();
    }

    protected int getPadding() {
        return DEFAULT_PADDING_PX;
    }

    @Override
    public int getIconWidth() {
        return this.getSize();
    }

    @Override
    public int getIconHeight() {
        return this.getSize();
    }

    public static enum SizeBias {
        ODD,
        EVEN;

    }
}

