/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import java.util.Set;
import javax.swing.Icon;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.OWLIcons;
import org.protege.editor.owl.ui.renderer.OWLAnnotationPropertyIcon;
import org.protege.editor.owl.ui.renderer.OWLClassIcon;
import org.protege.editor.owl.ui.renderer.OWLDataPropertyIcon;
import org.protege.editor.owl.ui.renderer.OWLIconProvider;
import org.protege.editor.owl.ui.renderer.OWLIndividualIcon;
import org.protege.editor.owl.ui.renderer.OWLObjectPropertyIcon;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.semanticweb.owlapi.util.OWLObjectVisitorAdapter;

public class OWLIconProviderImpl
extends OWLObjectVisitorAdapter
implements OWLIconProvider {
    private Icon icon;
    private final Icon primitiveClassIcon = new OWLClassIcon(OWLClassIcon.Type.PRIMITIVE);
    private final Icon definedClassIcon = new OWLClassIcon(OWLClassIcon.Type.DEFINED);
    private final Icon objectPropertyIcon = new OWLObjectPropertyIcon();
    private final Icon dataPropertyIcon = new OWLDataPropertyIcon();
    private final Icon annotationPropertyIcon = new OWLAnnotationPropertyIcon();
    private final Icon individualIcon = new OWLIndividualIcon();
    private final Icon dataTypeIcon = OWLIcons.getIcon("datarange.png");
    private final Icon ontologyIcon = OWLIcons.getIcon("ontology.png");
    private final Icon ontologyMissing = OWLIcons.getIcon("ontology.missing.png");
    private OWLModelManager owlModelManager;

    public OWLIconProviderImpl(OWLModelManager owlModelManager) {
        this.owlModelManager = owlModelManager;
    }

    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public Icon getIcon(OWLObject owlObject) {
        try {
            this.icon = null;
            owlObject.accept((OWLObjectVisitor)this);
            return this.icon;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void visit(OWLObjectIntersectionOf owlAnd) {
        this.icon = this.primitiveClassIcon;
    }

    public void visit(OWLDatatype owlDatatype) {
        this.icon = this.dataTypeIcon;
    }

    public void visit(OWLDataOneOf owlDataEnumeration) {
        this.icon = this.dataTypeIcon;
    }

    public void visit(OWLDataAllValuesFrom owlDataAllRestriction) {
        this.icon = this.primitiveClassIcon;
    }

    public void visit(OWLDataProperty owlDataProperty) {
        this.icon = this.dataPropertyIcon;
    }

    public void visit(OWLDataSomeValuesFrom owlDataSomeValuesFrom) {
        this.icon = this.primitiveClassIcon;
    }

    public void visit(OWLDataHasValue owlDataValueRestriction) {
        this.icon = this.primitiveClassIcon;
    }

    public void visit(OWLDifferentIndividualsAxiom owlDifferentIndividualsAxiom) {
        this.icon = this.individualIcon;
    }

    public void visit(OWLDisjointDataPropertiesAxiom owlDisjointDataPropertiesAxiom) {
        this.icon = this.dataPropertyIcon;
    }

    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.icon = this.objectPropertyIcon;
    }

    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.icon = this.objectPropertyIcon;
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.icon = this.objectPropertyIcon;
    }

    public void visit(OWLHasKeyAxiom owlHasKeyAxiom) {
        this.icon = this.primitiveClassIcon;
    }

    public void visit(OWLDatatypeDefinitionAxiom owlDatatypeDefinitionAxiom) {
        this.icon = this.dataTypeIcon;
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.icon = this.objectPropertyIcon;
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.icon = this.objectPropertyIcon;
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom owlEquivalentObjectPropertiesAxiom) {
        this.icon = this.objectPropertyIcon;
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom owlNegativeDataPropertyAssertionAxiom) {
        this.icon = this.individualIcon;
    }

    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.icon = this.objectPropertyIcon;
    }

    public void visit(OWLObjectPropertyAssertionAxiom owlObjectPropertyAssertionAxiom) {
        this.icon = this.individualIcon;
    }

    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this.icon = this.objectPropertyIcon;
    }

    public void visit(OWLNamedIndividual owlIndividual) {
        this.icon = this.individualIcon;
    }

    public void visit(OWLAnonymousIndividual individual) {
        this.icon = this.individualIcon;
    }

    public void visit(OWLObjectAllValuesFrom owlObjectAllRestriction) {
        this.icon = this.primitiveClassIcon;
    }

    public void visit(OWLObjectMinCardinality desc) {
        this.icon = this.primitiveClassIcon;
    }

    public void visit(OWLObjectExactCardinality desc) {
        this.icon = this.primitiveClassIcon;
    }

    public void visit(OWLObjectMaxCardinality desc) {
        this.icon = this.primitiveClassIcon;
    }

    public void visit(OWLObjectHasSelf desc) {
        this.icon = this.primitiveClassIcon;
    }

    public void visit(OWLDataMinCardinality desc) {
        this.icon = this.primitiveClassIcon;
    }

    public void visit(OWLDataExactCardinality desc) {
        this.icon = this.primitiveClassIcon;
    }

    public void visit(OWLDataMaxCardinality desc) {
        this.icon = this.primitiveClassIcon;
    }

    public void visit(OWLObjectProperty owlObjectProperty) {
        this.icon = this.objectPropertyIcon;
    }

    public void visit(OWLObjectSomeValuesFrom owlObjectSomeValuesFrom) {
        this.icon = this.primitiveClassIcon;
    }

    public void visit(OWLObjectHasValue owlObjectValueRestriction) {
        this.icon = this.primitiveClassIcon;
    }

    public void visit(OWLObjectComplementOf owlNot) {
        this.icon = this.primitiveClassIcon;
    }

    public void visit(OWLOntology owlOntology) {
        this.icon = this.ontologyIcon;
    }

    public void visit(OWLObjectUnionOf owlOr) {
        this.icon = this.primitiveClassIcon;
    }

    public void visit(OWLDeclarationAxiom owlDeclarationAxiom) {
        owlDeclarationAxiom.getEntity().accept((OWLObjectVisitor)this);
    }

    public void visit(OWLSubClassOfAxiom owlSubClassAxiom) {
        this.icon = this.primitiveClassIcon;
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom owlNegativeObjectPropertyAssertionAxiom) {
        this.icon = this.individualIcon;
    }

    public void visit(OWLAsymmetricObjectPropertyAxiom owlAntiSymmetricObjectPropertyAxiom) {
        this.icon = this.objectPropertyIcon;
    }

    public void visit(OWLReflexiveObjectPropertyAxiom owlReflexiveObjectPropertyAxiom) {
        this.icon = this.objectPropertyIcon;
    }

    public void visit(OWLDisjointClassesAxiom owlDisjointClassesAxiom) {
        this.icon = this.primitiveClassIcon;
    }

    public void visit(OWLDataPropertyDomainAxiom owlDataPropertyDomainAxiom) {
        this.icon = this.dataPropertyIcon;
    }

    public void visit(OWLDisjointUnionAxiom owlDisjointUnionAxiom) {
        this.icon = this.primitiveClassIcon;
    }

    public void visit(OWLSymmetricObjectPropertyAxiom owlSymmetricObjectPropertyAxiom) {
        this.icon = this.objectPropertyIcon;
    }

    public void visit(OWLDataPropertyRangeAxiom owlDataPropertyRangeAxiom) {
        this.icon = this.dataPropertyIcon;
    }

    public void visit(OWLFunctionalDataPropertyAxiom owlFunctionalDataPropertyAxiom) {
        this.icon = this.dataPropertyIcon;
    }

    public void visit(OWLEquivalentDataPropertiesAxiom owlEquivalentDataPropertiesAxiom) {
        this.icon = this.dataPropertyIcon;
    }

    public void visit(OWLEquivalentClassesAxiom owlEquivalentClassesAxiom) {
        this.icon = this.primitiveClassIcon;
    }

    public void visit(OWLDataPropertyAssertionAxiom owlDataPropertyAssertionAxiom) {
        this.icon = this.individualIcon;
    }

    public void visit(OWLTransitiveObjectPropertyAxiom owlTransitiveObjectPropertyAxiom) {
        this.icon = this.objectPropertyIcon;
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom owlIrreflexiveObjectPropertyAxiom) {
        this.icon = this.objectPropertyIcon;
    }

    public void visit(OWLSubDataPropertyOfAxiom owlDataSubPropertyAxiom) {
        this.icon = this.dataPropertyIcon;
    }

    public void visit(OWLSameIndividualAxiom owlSameIndividualsAxiom) {
        this.icon = this.individualIcon;
    }

    public void visit(OWLClassAssertionAxiom owlClassAssertionAxiom) {
        this.icon = this.individualIcon;
    }

    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this.icon = this.objectPropertyIcon;
    }

    public void visit(OWLClass owlClass) {
        for (OWLOntology ont : this.owlModelManager.getActiveOntologies()) {
            if (!this.isDefined(owlClass, ont)) continue;
            this.icon = this.definedClassIcon;
            return;
        }
        this.icon = this.primitiveClassIcon;
    }

    private boolean isDefined(OWLClass owlClass, OWLOntology ontology) {
        if (EntitySearcher.isDefined((OWLClass)owlClass, (OWLOntology)ontology)) {
            return true;
        }
        Set axioms = ontology.getDisjointUnionAxioms(owlClass);
        return !axioms.isEmpty();
    }

    public void visit(OWLObjectOneOf owlEnumeration) {
        this.icon = this.primitiveClassIcon;
    }

    public void visit(OWLAnnotationProperty owlAnnotationProperty) {
        this.icon = this.annotationPropertyIcon;
    }

    public void visit(OWLAnnotationAssertionAxiom owlAnnotationAssertionAxiom) {
        this.icon = this.annotationPropertyIcon;
    }

    public void visit(OWLSubAnnotationPropertyOfAxiom owlSubAnnotationPropertyOfAxiom) {
        this.icon = this.annotationPropertyIcon;
    }

    public void visit(OWLAnnotationPropertyDomainAxiom owlAnnotationPropertyDomainAxiom) {
        this.icon = this.annotationPropertyIcon;
    }

    public void visit(OWLAnnotationPropertyRangeAxiom owlAnnotationPropertyRangeAxiom) {
        this.icon = this.annotationPropertyIcon;
    }
}

