/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.renderer.OWLObjectRenderer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.OWLClassExpressionVisitorAdapter;
import org.semanticweb.owlapi.util.OWLObjectVisitorAdapter;

public class OWLObjectRendererDLSyntax
extends OWLObjectVisitorAdapter
implements OWLObjectRenderer {
    private StringBuffer buffer;
    private BracketWriter bracketWriter;
    private OWLModelManager mngr;
    int lastNewLineIndex = 0;
    int currentIndex = 0;

    public OWLObjectRendererDLSyntax(OWLModelManager mngr) {
        this.mngr = mngr;
        this.buffer = new StringBuffer();
        this.bracketWriter = new BracketWriter();
    }

    @Override
    public String render(OWLObject object) {
        this.reset();
        try {
            object.accept((OWLObjectVisitor)this);
            return this.buffer.toString();
        }
        catch (Exception e) {
            return "<Error! " + e.getMessage() + ">";
        }
    }

    protected String getAndKeyWord() {
        return "\u2293";
    }

    protected String getOrKeyWord() {
        return "\u2294";
    }

    protected String getNotKeyWord() {
        return "\u00ac";
    }

    protected String getSomeKeyWord() {
        return "\u2203";
    }

    protected String getAllKeyWord() {
        return "\u2200";
    }

    protected String getMinKeyWord() {
        return "\u2265";
    }

    protected String getMaxKeyWord() {
        return "\u2264";
    }

    protected String getExactlyKeyWord() {
        return "=";
    }

    protected String getRendering(OWLEntity entity) {
        return this.mngr.getRendering((OWLObject)entity);
    }

    protected void write(String s) {
        int index = s.indexOf(10);
        if (index != -1) {
            this.lastNewLineIndex = this.currentIndex + index;
        }
        this.currentIndex += s.length();
        this.buffer.append(s);
    }

    protected int getIndent() {
        return this.currentIndex - this.lastNewLineIndex;
    }

    protected void insertIndent(int indent) {
        for (int i = 0; i < indent; ++i) {
            this.write(" ");
        }
    }

    protected void writeAndKeyword() {
        this.write(this.getAndKeyWord());
        this.write(" ");
    }

    public void reset() {
        this.lastNewLineIndex = 0;
        this.currentIndex = 0;
        this.buffer = new StringBuffer();
    }

    public String getText() {
        return this.buffer.toString();
    }

    private static List<OWLClassExpression> sort(Set<OWLClassExpression> descriptions) {
        ArrayList<OWLClassExpression> sortedDescs = new ArrayList<OWLClassExpression>(descriptions);
        Collections.sort(sortedDescs, new Comparator<OWLClassExpression>(){

            @Override
            public int compare(OWLClassExpression o1, OWLClassExpression o2) {
                if (o1 instanceof OWLClass) {
                    return -1;
                }
                return 1;
            }
        });
        return sortedDescs;
    }

    public void visit(OWLObjectIntersectionOf node) {
        List<OWLClassExpression> ops = OWLObjectRendererDLSyntax.sort(node.getOperands());
        for (int i = 0; i < ops.size(); ++i) {
            OWLClassExpression curOp = ops.get(i);
            int indent = this.getIndent();
            curOp.accept((OWLObjectVisitor)this);
            if (i >= ops.size() - 1) continue;
            this.write("\n");
            this.insertIndent(indent);
            this.writeAndKeyword();
        }
    }

    public void visit(OWLLiteral node) {
        if (node.isRDFPlainLiteral()) {
            this.write("\"");
            this.write(node.getLiteral());
            this.write("\"");
            if (node.getLang() != null) {
                this.write("@");
                this.write(node.getLang());
            }
        } else {
            this.write("\"");
            this.write(node.getLiteral());
            this.write("\"^^");
            node.getDatatype().accept((OWLObjectVisitor)this);
        }
    }

    public void visit(OWLDatatype node) {
        this.visit(node.getIRI());
    }

    public void visit(IRI iri) {
        Optional remainder = iri.getRemainder();
        if (remainder.isPresent()) {
            this.write((String)remainder.get());
        } else {
            this.write(iri.toString());
        }
    }

    public void visit(OWLDataOneOf node) {
        this.write("{");
        Iterator it = node.getValues().iterator();
        while (it.hasNext()) {
            ((OWLLiteral)it.next()).accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.write(" ");
        }
        this.write("}");
    }

    public void visit(OWLDataAllValuesFrom node) {
        this.write(this.getAllKeyWord());
        this.write(" ");
        node.getProperty().accept((OWLObjectVisitor)this);
        this.write(" ");
        ((OWLDataRange)node.getFiller()).accept((OWLObjectVisitor)this);
    }

    public void visit(OWLDataProperty node) {
        this.write(this.getRendering((OWLEntity)node));
    }

    public void visit(OWLDataSomeValuesFrom node) {
        this.write(this.getSomeKeyWord());
        this.write(" ");
        node.getProperty().accept((OWLObjectVisitor)this);
        this.write(" ");
        ((OWLDataRange)node.getFiller()).accept((OWLObjectVisitor)this);
    }

    public void visit(OWLDataHasValue node) {
        this.write(this.getSomeKeyWord());
        this.write(" ");
        node.getProperty().accept((OWLObjectVisitor)this);
        this.write(" {");
        ((OWLLiteral)node.getValue()).accept((OWLObjectVisitor)this);
        this.write("}");
    }

    public void visit(OWLNamedIndividual node) {
        this.write(this.getRendering((OWLEntity)node));
    }

    public void visit(OWLObjectAllValuesFrom node) {
        this.write(this.getAllKeyWord());
        this.write(" ");
        node.getProperty().accept((OWLObjectVisitor)this);
        this.write(" ");
        this.writeOpenBracket((OWLClassExpression)node.getFiller());
        ((OWLClassExpression)node.getFiller()).accept((OWLObjectVisitor)this);
        this.writeCloseBracket((OWLClassExpression)node.getFiller());
    }

    public void visit(OWLObjectMinCardinality desc) {
        this.writeCardinality((OWLObjectCardinalityRestriction)desc, this.getMinKeyWord());
    }

    public void visit(OWLObjectExactCardinality desc) {
        this.writeCardinality((OWLObjectCardinalityRestriction)desc, this.getExactlyKeyWord());
    }

    public void visit(OWLObjectMaxCardinality desc) {
        this.writeCardinality((OWLObjectCardinalityRestriction)desc, this.getMaxKeyWord());
    }

    private void writeCardinality(OWLObjectCardinalityRestriction desc, String keyword) {
        this.write(keyword);
        this.write(" ");
        this.write(Integer.toString(desc.getCardinality()));
        this.write(" ");
        desc.getProperty().accept((OWLObjectVisitor)this);
        this.write(" ");
        this.writeOpenBracket((OWLClassExpression)desc.getFiller());
        ((OWLClassExpression)desc.getFiller()).accept((OWLObjectVisitor)this);
        this.writeCloseBracket((OWLClassExpression)desc.getFiller());
    }

    public void visit(OWLDataMinCardinality desc) {
        this.writeCardinality((OWLDataCardinalityRestriction)desc, this.getMinKeyWord());
    }

    public void visit(OWLDataExactCardinality desc) {
        this.writeCardinality((OWLDataCardinalityRestriction)desc, this.getExactlyKeyWord());
    }

    public void visit(OWLDataMaxCardinality desc) {
        this.writeCardinality((OWLDataCardinalityRestriction)desc, this.getMaxKeyWord());
    }

    private void writeCardinality(OWLDataCardinalityRestriction desc, String keyword) {
        this.write(keyword);
        this.write(" ");
        this.write(Integer.toString(desc.getCardinality()));
        this.write(" ");
        desc.getProperty().accept((OWLObjectVisitor)this);
        this.write(" ");
        this.writeOpenBracket((OWLDataRange)desc.getFiller());
        ((OWLDataRange)desc.getFiller()).accept((OWLObjectVisitor)this);
        this.writeCloseBracket((OWLDataRange)desc.getFiller());
    }

    public void visit(OWLObjectProperty node) {
        this.write(this.getRendering((OWLEntity)node));
    }

    public void visit(OWLObjectSomeValuesFrom node) {
        this.write(this.getSomeKeyWord());
        this.write(" ");
        node.getProperty().accept((OWLObjectVisitor)this);
        this.write(" ");
        this.writeOpenBracket((OWLClassExpression)node.getFiller());
        ((OWLClassExpression)node.getFiller()).accept((OWLObjectVisitor)this);
        this.writeCloseBracket((OWLClassExpression)node.getFiller());
    }

    public void visit(OWLObjectHasValue node) {
        this.write(this.getSomeKeyWord());
        this.write(" ");
        node.getProperty().accept((OWLObjectVisitor)this);
        this.write(" {");
        ((OWLIndividual)node.getValue()).accept((OWLObjectVisitor)this);
        this.write("}");
    }

    public void visit(OWLObjectComplementOf node) {
        this.writeNotKeyword();
        this.write(" ");
        this.writeOpenBracket(node.getOperand());
        node.getOperand().accept((OWLObjectVisitor)this);
        this.writeCloseBracket(node.getOperand());
    }

    protected void writeNotKeyword() {
        this.write(this.getNotKeyWord());
    }

    public void visit(OWLObjectUnionOf node) {
        int indent = this.getIndent();
        Iterator<OWLClassExpression> it = OWLObjectRendererDLSyntax.sort(node.getOperands()).iterator();
        while (it.hasNext()) {
            OWLClassExpression curOp = it.next();
            this.writeOpenBracket(curOp);
            curOp.accept((OWLObjectVisitor)this);
            this.writeCloseBracket(curOp);
            if (!it.hasNext()) continue;
            this.write("\n");
            this.insertIndent(indent);
            this.writeOrKeyword();
        }
    }

    private void writeOrKeyword() {
        this.write(this.getOrKeyWord());
        this.write(" ");
    }

    public void visit(OWLClass node) {
        this.write(this.getRendering((OWLEntity)node));
    }

    public void visit(OWLObjectOneOf node) {
        this.write("{");
        int size = node.getIndividuals().size();
        int count = 0;
        for (Object op : node.getIndividuals()) {
            ((OWLIndividual)op).accept((OWLObjectVisitor)this);
            if (count >= size - 1) continue;
            this.write(" ");
        }
        this.write("}");
    }

    public void visit(OWLDisjointClassesAxiom node) {
        Iterator<OWLClassExpression> it = OWLObjectRendererDLSyntax.sort(node.getClassExpressions()).iterator();
        while (it.hasNext()) {
            it.next().accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.write("  \u2291 \u00ac ");
        }
    }

    public void visit(OWLEquivalentClassesAxiom node) {
        Iterator<OWLClassExpression> it = OWLObjectRendererDLSyntax.sort(node.getClassExpressions()).iterator();
        while (it.hasNext()) {
            it.next().accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.write("  \u2261  ");
        }
    }

    public void visit(OWLSubClassOfAxiom node) {
        node.getSubClass().accept((OWLObjectVisitor)this);
        this.write(" \u2291 ");
        node.getSuperClass().accept((OWLObjectVisitor)this);
    }

    private void writeOpenBracket(OWLClassExpression description) {
        description.accept((OWLClassExpressionVisitor)this.bracketWriter);
        if (this.bracketWriter.writeBrackets()) {
            this.write("(");
        }
    }

    private void writeOpenBracket(OWLDataRange dataRange) {
        dataRange.accept((OWLDataVisitor)this.bracketWriter);
        if (this.bracketWriter.writeBrackets()) {
            this.write("(");
        }
    }

    private void writeCloseBracket(OWLClassExpression description) {
        description.accept((OWLClassExpressionVisitor)this.bracketWriter);
        if (this.bracketWriter.writeBrackets()) {
            this.write(")");
        }
    }

    private void writeCloseBracket(OWLDataRange dataRange) {
        dataRange.accept((OWLDataVisitor)this.bracketWriter);
        if (this.bracketWriter.writeBrackets()) {
            this.write(")");
        }
    }

    public void visit(OWLOntology ontology) {
        this.write(ontology.getOntologyID().toString());
    }

    private class BracketWriter
    extends OWLClassExpressionVisitorAdapter
    implements OWLDataVisitor {
        boolean nested = false;

        private BracketWriter() {
        }

        public boolean writeBrackets() {
            return this.nested;
        }

        public void visit(OWLObjectIntersectionOf owlAnd) {
            this.nested = true;
        }

        public void visit(OWLDataAllValuesFrom owlDataAllRestriction) {
            this.nested = true;
        }

        public void visit(OWLDataSomeValuesFrom owlDataSomeValuesFrom) {
            this.nested = true;
        }

        public void visit(OWLDataHasValue owlDataValueRestriction) {
            this.nested = true;
        }

        public void visit(OWLObjectAllValuesFrom owlObjectAllRestriction) {
            this.nested = true;
        }

        public void visit(OWLObjectSomeValuesFrom owlObjectSomeValuesFrom) {
            this.nested = true;
        }

        public void visit(OWLObjectHasValue owlObjectValueRestriction) {
            this.nested = true;
        }

        public void visit(OWLObjectComplementOf owlNot) {
            this.nested = true;
        }

        public void visit(OWLObjectUnionOf owlOr) {
            this.nested = true;
        }

        public void visit(OWLClass owlClass) {
            this.nested = false;
        }

        public void visit(OWLObjectOneOf owlObjectOneOf) {
            this.nested = false;
        }

        public void visit(OWLObjectMinCardinality desc) {
            this.nested = true;
        }

        public void visit(OWLObjectExactCardinality desc) {
            this.nested = true;
        }

        public void visit(OWLObjectMaxCardinality desc) {
            this.nested = true;
        }

        public void visit(OWLObjectHasSelf desc) {
            this.nested = true;
        }

        public void visit(OWLDataMinCardinality desc) {
            this.nested = true;
        }

        public void visit(OWLDataExactCardinality desc) {
            this.nested = true;
        }

        public void visit(OWLDataMaxCardinality desc) {
            this.nested = true;
        }

        public void visit(OWLDatatype node) {
            this.nested = false;
        }

        public void visit(OWLDataComplementOf node) {
            this.nested = false;
        }

        public void visit(OWLDataIntersectionOf owlDataIntersectionOf) {
            this.nested = true;
        }

        public void visit(OWLDataUnionOf owlDataUnionOf) {
            this.nested = true;
        }

        public void visit(OWLDatatypeRestriction owlDatatypeRestriction) {
            this.nested = false;
        }

        public void visit(OWLDataOneOf node) {
            this.nested = false;
        }

        public void visit(OWLLiteral node) {
            this.nested = false;
        }

        public void visit(OWLFacetRestriction node) {
            this.nested = false;
        }
    }
}

