/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import org.protege.editor.core.ui.action.ProtegeDynamicAction;
import org.protege.editor.core.ui.util.Icons;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.ui.renderer.OWLEntityAnnotationValueRenderer;
import org.protege.editor.owl.ui.renderer.OWLEntityRendererImpl;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;
import org.protege.editor.owl.ui.renderer.plugin.RendererPlugin;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;

public class RenderByProperty
extends ProtegeDynamicAction {
    private static final long serialVersionUID = 8119262495644333132L;
    private static final OWLAnnotationProperty LABEL = OWLManager.getOWLDataFactory().getRDFSLabel();
    private JMenu menu;
    private OWLModelManagerListener listener;

    public void actionPerformed(ActionEvent e) {
    }

    public void rebuildChildMenuItems(JMenu thisMenuItem) {
        Set<OWLAnnotationProperty> annotationProperties = this.getAnnotationProperties();
        ArrayList<OWLAnnotationProperty> annotationPropertiesList = new ArrayList<OWLAnnotationProperty>(annotationProperties);
        Collections.sort(annotationPropertiesList, this.getComparator());
        for (OWLAnnotationProperty prop : annotationPropertiesList) {
            PropertyMenuItem item = new PropertyMenuItem(prop);
            thisMenuItem.add(item);
        }
    }

    private Set<OWLAnnotationProperty> getAnnotationProperties() {
        HashSet<OWLAnnotationProperty> annotationProperties = new HashSet<OWLAnnotationProperty>();
        Set<OWLOntology> ontologies = this.getOWLModelManager().getActiveOntologies();
        for (OWLOntology ontology : ontologies) {
            annotationProperties.addAll(ontology.getAnnotationPropertiesInSignature());
        }
        return annotationProperties;
    }

    public OWLModelManager getOWLModelManager() {
        return (OWLModelManager)this.getEditorKit().getModelManager();
    }

    private Comparator<OWLAnnotationProperty> getComparator() {
        return new Comparator<OWLAnnotationProperty>(){

            @Override
            public int compare(OWLAnnotationProperty p1, OWLAnnotationProperty p2) {
                return RenderByProperty.this.getOWLModelManager().getRendering((OWLObject)p1).compareTo(RenderByProperty.this.getOWLModelManager().getRendering((OWLObject)p2));
            }
        };
    }

    public void setMenu(JMenu menu) {
        this.menu = menu;
        this.updateCheckedStatus();
    }

    public void initialise() throws Exception {
        this.listener = new OWLModelManagerListener(){

            @Override
            public void handleChange(OWLModelManagerChangeEvent event) {
                if (event.isType(EventType.ENTITY_RENDERER_CHANGED)) {
                    RenderByProperty.this.updateCheckedStatus();
                }
            }
        };
        this.getOWLModelManager().addListener(this.listener);
    }

    private void updateCheckedStatus() {
        if (this.menu != null) {
            RendererPlugin plugin = OWLRendererPreferences.getInstance().getRendererPlugin();
            this.markCheckedMenu(this.isMyRendererPlugin(plugin) && this.isConfigured(plugin));
        }
    }

    private void markCheckedMenu(boolean marked) {
        if (marked) {
            JCheckBoxMenuItem it = new JCheckBoxMenuItem();
            it.setSelected(true);
            this.menu.setIcon(Icons.getIcon((String)"hierarchy.collapsed.gif"));
        } else {
            this.menu.setIcon(null);
        }
    }

    public void dispose() throws Exception {
        this.getOWLModelManager().removeListener(this.listener);
    }

    protected boolean isMyRendererPlugin(RendererPlugin plugin) {
        return plugin.getRendererClassName().equals(OWLEntityAnnotationValueRenderer.class.getName());
    }

    protected boolean isConfigured(RendererPlugin plugin) {
        List<IRI> annotations = OWLRendererPreferences.getInstance().getAnnotationIRIs();
        return annotations.size() == 1 && !annotations.iterator().next().equals((Object)LABEL.getIRI());
    }

    protected void configure(OWLAnnotationProperty prop) {
        OWLRendererPreferences.getInstance().setAnnotations(Collections.singletonList(prop.getIRI()));
    }

    private void setRendering(OWLAnnotationProperty prop) {
        OWLRendererPreferences preferences = OWLRendererPreferences.getInstance();
        for (RendererPlugin plugin : preferences.getRendererPlugins()) {
            if (!this.isMyRendererPlugin(plugin)) continue;
            preferences.setRendererPlugin(plugin);
            this.configure(prop);
            this.getOWLModelManager().refreshRenderer();
            break;
        }
    }

    private void resetRendering() {
        OWLRendererPreferences preferences = OWLRendererPreferences.getInstance();
        preferences.setRendererPlugin(preferences.getRendererPluginByClassName(OWLEntityRendererImpl.class.getName()));
        this.getOWLModelManager().refreshRenderer();
    }

    class PropertyMenuItem
    extends JCheckBoxMenuItem {
        private OWLAnnotationProperty property;

        public PropertyMenuItem(OWLAnnotationProperty prop) {
            super(RenderByProperty.this.getOWLModelManager().getRendering((OWLObject)prop));
            this.property = prop;
            this.setToolTipText(this.property.getIRI().toString());
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PropertyMenuItem.this.onStateChanged();
                }
            });
            this.setSelected(this.isRenderingProperty());
        }

        private boolean isRenderingProperty() {
            if (!RenderByProperty.this.isMyRendererPlugin(OWLRendererPreferences.getInstance().getRendererPlugin())) {
                return false;
            }
            List<IRI> annotations = OWLRendererPreferences.getInstance().getAnnotationIRIs();
            for (IRI iri : annotations) {
                if (!iri.equals((Object)this.property.getIRI())) continue;
                return true;
            }
            return false;
        }

        private void onStateChanged() {
            if (this.isSelected()) {
                RenderByProperty.this.setRendering(this.property);
            } else {
                RenderByProperty.this.resetRendering();
            }
        }
    }
}

