/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.selector;

import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.core.ui.view.ViewComponent;
import org.protege.editor.core.ui.view.ViewComponentPlugin;
import org.protege.editor.core.ui.view.ViewComponentPluginAdapter;
import org.protege.editor.core.ui.workspace.Workspace;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.util.OWLDataTypeUtils;
import org.protege.editor.owl.ui.list.OWLObjectList;
import org.protege.editor.owl.ui.selector.AbstractSelectorPanel;
import org.protege.editor.owl.ui.view.AbstractOWLViewComponent;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class OWLDataTypeSelectorPanel
extends AbstractSelectorPanel<OWLDatatype> {
    private static final long serialVersionUID = 1925753640367589134L;
    private AbstractOWLViewComponent vc;
    private OWLObjectList<OWLDatatype> list;
    private Map<ChangeListener, ListSelectionListener> selListenerWrappers = new HashMap<ChangeListener, ListSelectionListener>();

    public OWLDataTypeSelectorPanel(OWLEditorKit editorKit) {
        super(editorKit);
    }

    public OWLDataTypeSelectorPanel(OWLEditorKit editorKit, boolean editable) {
        super(editorKit, editable);
    }

    public OWLDataTypeSelectorPanel(OWLEditorKit editorKit, boolean editable, boolean autoCreateUI) {
        super(editorKit, editable, autoCreateUI);
    }

    @Override
    public void setSelection(OWLDatatype dt) {
        this.list.setSelectedValue(dt, true);
    }

    @Override
    public void setSelection(Set<OWLDatatype> ranges) {
        this.list.setSelectedValues(ranges, true);
    }

    @Override
    public OWLDatatype getSelectedObject() {
        return (OWLDatatype)this.list.getSelectedValue();
    }

    @Override
    public Set<OWLDatatype> getSelectedObjects() {
        return new HashSet<OWLDatatype>(this.list.getSelectedOWLObjects());
    }

    @Override
    protected ViewComponentPlugin getViewComponentPlugin() {
        return new ViewComponentPluginAdapter(){

            public String getLabel() {
                return "Datatypes";
            }

            public Workspace getWorkspace() {
                return OWLDataTypeSelectorPanel.this.getOWLEditorKit().getWorkspace();
            }

            public ViewComponent newInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
                OWLDataTypeSelectorPanel.this.vc = new OWLDatatypeListView();
                OWLDataTypeSelectorPanel.this.vc.setup((ViewComponentPlugin)this);
                return OWLDataTypeSelectorPanel.this.vc;
            }
        };
    }

    @Override
    public void dispose() {
        this.vc.dispose();
    }

    @Override
    public void addSelectionListener(ChangeListener listener) {
        this.list.addListSelectionListener(this.wrapListener(listener));
    }

    @Override
    public void removeSelectionListener(ChangeListener listener) {
        this.list.removeListSelectionListener(this.wrapListener(listener));
    }

    private ListSelectionListener wrapListener(final ChangeListener listener) {
        ListSelectionListener l = this.selListenerWrappers.get(listener);
        if (l == null) {
            l = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    listener.stateChanged(new ChangeEvent(OWLDataTypeSelectorPanel.this.list));
                }
            };
            this.selListenerWrappers.put(listener, l);
        }
        return l;
    }

    private List<OWLDatatype> getDatatypeList() {
        OWLOntologyManager mngr = this.getOWLModelManager().getOWLOntologyManager();
        ArrayList<OWLDatatype> datatypeList = new ArrayList<OWLDatatype>(new OWLDataTypeUtils(mngr).getKnownDatatypes(this.getOWLModelManager().getActiveOntologies()));
        Collections.sort(datatypeList, this.getOWLModelManager().getOWLObjectComparator());
        return datatypeList;
    }

    private void rebuildDatatypeList() {
        OWLDatatype selected = (OWLDatatype)this.list.getSelectedValue();
        List<OWLDatatype> datatypes = this.getDatatypeList();
        this.list.setListData(datatypes.toArray(new OWLDatatype[datatypes.size()]));
        if (datatypes.contains(selected)) {
            this.list.setSelectedValue(selected, true);
        }
    }

    private class OWLDatatypeListView
    extends AbstractOWLViewComponent {
        private static final long serialVersionUID = -2407766608313199261L;
        private OWLOntologyChangeListener ontologyChangeListener;
        private OWLModelManagerListener p4Listener;

        private OWLDatatypeListView() {
            this.ontologyChangeListener = new UpdateDatatypeListListener();
            this.p4Listener = new ActiveOntologyChangedListener();
        }

        @Override
        protected void initialiseOWLView() throws Exception {
            this.setLayout(new BorderLayout());
            OWLDataTypeSelectorPanel.this.list = new OWLObjectList(this.getOWLEditorKit());
            List datatypes = OWLDataTypeSelectorPanel.this.getDatatypeList();
            OWLDatatype[] objects = datatypes.toArray(new OWLDatatype[datatypes.size()]);
            OWLDataTypeSelectorPanel.this.list.setListData(objects);
            OWLDataTypeSelectorPanel.this.list.setSelectedIndex(0);
            this.add(ComponentFactory.createScrollPane((JComponent)OWLDataTypeSelectorPanel.this.list));
            this.getOWLModelManager().addOntologyChangeListener(this.ontologyChangeListener);
            this.getOWLModelManager().addListener(this.p4Listener);
        }

        @Override
        protected void disposeOWLView() {
            this.getOWLModelManager().removeOntologyChangeListener(this.ontologyChangeListener);
            this.getOWLModelManager().removeListener(this.p4Listener);
        }
    }

    private class ActiveOntologyChangedListener
    implements OWLModelManagerListener {
        private ActiveOntologyChangedListener() {
        }

        @Override
        public void handleChange(OWLModelManagerChangeEvent event) {
            switch (event.getType()) {
                case ACTIVE_ONTOLOGY_CHANGED: {
                    OWLDataTypeSelectorPanel.this.rebuildDatatypeList();
                }
            }
        }
    }

    private class UpdateDatatypeListListener
    implements OWLOntologyChangeListener {
        private UpdateDatatypeListListener() {
        }

        public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
            if (this.datatypesMightHaveChanged(changes)) {
                OWLDataTypeSelectorPanel.this.rebuildDatatypeList();
            }
        }

        private boolean datatypesMightHaveChanged(List<? extends OWLOntologyChange> changes) {
            for (OWLOntologyChange oWLOntologyChange : changes) {
                if (!(oWLOntologyChange instanceof OWLAxiomChange)) continue;
                for (OWLEntity e : ((OWLAxiomChange)oWLOntologyChange).getAxiom().getSignature()) {
                    if (!(e instanceof OWLDatatype) || e.isBuiltIn()) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

