/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.tree;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.protege.editor.core.ui.RefreshableComponent;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProvider;
import org.protege.editor.owl.ui.renderer.OWLEntityRendererListener;
import org.protege.editor.owl.ui.renderer.OWLModelManagerEntityRenderer;
import org.protege.editor.owl.ui.tree.OWLObjectTree;
import org.protege.editor.owl.ui.tree.OWLObjectTreeCellRenderer;
import org.protege.editor.owl.ui.tree.OWLObjectTreeNode;
import org.protege.editor.owl.ui.tree.OWLTreePreferences;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;

public class OWLModelManagerTree<N extends OWLObject>
extends OWLObjectTree<N>
implements RefreshableComponent {
    private static final long serialVersionUID = 9168555447316716896L;
    private OWLModelManagerListener listener;
    private OWLEntityRendererListener rendererListener;
    public OWLModelManagerEntityRenderer currentRenderer = null;

    public OWLModelManagerTree(OWLEditorKit owlEditorKit, OWLObjectHierarchyProvider<N> provider) {
        super(owlEditorKit, provider);
        this.initialise(owlEditorKit);
    }

    public OWLModelManagerTree(OWLEditorKit owlEditorKit, OWLObjectHierarchyProvider<N> provider, Set<N> rootObjects) {
        super(owlEditorKit, provider, rootObjects, owlEditorKit.getModelManager().getOWLObjectComparator());
        this.initialise(owlEditorKit);
    }

    private void initialise(OWLEditorKit owlEditorKit) {
        OWLObjectTreeCellRenderer renderer = new OWLObjectTreeCellRenderer(owlEditorKit);
        renderer.setWrap(false);
        this.setCellRenderer(renderer);
        this.setHighlightKeywords(false);
        this.setupListener();
        this.installPopupMenu();
        this.setRowHeight(-1);
        this.autoExpandTree();
    }

    public void refreshComponent() {
        this.reload();
    }

    @Override
    public void reload() {
        super.reload();
        this.autoExpandTree();
    }

    public void setHighlightKeywords(boolean b) {
        TreeCellRenderer ren = this.getCellRenderer();
        if (ren instanceof OWLObjectTreeCellRenderer) {
            ((OWLObjectTreeCellRenderer)ren).setHighlightKeywords(b);
        }
    }

    private void autoExpandTree() {
        OWLTreePreferences prefs = OWLTreePreferences.getInstance();
        if (!prefs.isAutoExpandEnabled()) {
            return;
        }
        OWLObjectHierarchyProvider prov = this.getProvider();
        for (OWLObject root : prov.getRoots()) {
            this.autoExpand(root, 0);
        }
    }

    private void autoExpand(N node, int currentDepth) {
        OWLTreePreferences prefs = OWLTreePreferences.getInstance();
        int maxDepth = prefs.getAutoExpansionDepthLimit();
        if (currentDepth >= maxDepth) {
            return;
        }
        OWLObjectHierarchyProvider<N> prov = this.getProvider();
        int childCountLimit = prefs.getAutoExpansionChildLimit();
        Set children = prov.getChildren(node);
        if (children.size() <= childCountLimit) {
            for (OWLObjectTreeNode treeNode : this.getNodes((OWLObject)node)) {
                TreePath path = new TreePath(treeNode.getPath());
                this.expandPath(path);
            }
            for (OWLObject child : prov.getChildren(node)) {
                this.autoExpand(child, currentDepth + 1);
            }
        }
    }

    private void setupListener() {
        this.listener = new OWLModelManagerListener(){

            @Override
            public void handleChange(OWLModelManagerChangeEvent event) {
                if (event.isType(EventType.ENTITY_RENDERER_CHANGED)) {
                    OWLModelManagerTree.this.refreshEntityRenderer();
                }
            }
        };
        this.getOWLModelManager().addListener(this.listener);
        this.rendererListener = new OWLEntityRendererListener(){

            @Override
            public void renderingChanged(OWLEntity entity, OWLModelManagerEntityRenderer renderer) {
                OWLModelManagerTree.this.handleRenderingChanged(entity);
            }
        };
        this.refreshEntityRenderer();
    }

    private void handleRenderingChanged(OWLEntity entity) {
        try {
            for (OWLObjectTreeNode node : this.getNodes((OWLObject)entity)) {
                DefaultTreeModel model = (DefaultTreeModel)this.getModel();
                model.nodeStructureChanged(node);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private void refreshEntityRenderer() {
        this.invalidate();
        if (this.currentRenderer != null) {
            this.currentRenderer.removeListener(this.rendererListener);
        }
        this.currentRenderer = this.getOWLModelManager().getOWLEntityRenderer();
        this.currentRenderer.addListener(this.rendererListener);
    }

    private void installPopupMenu() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                OWLModelManagerTree.this.handleMouseEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                OWLModelManagerTree.this.handleMouseEvent(e);
            }
        });
    }

    protected void handleMouseEvent(MouseEvent e) {
        TreePath treePath;
        if (e.isPopupTrigger() && (treePath = this.getPathForLocation(e.getX(), e.getY())) != null) {
            this.handlePopupMenuInvoked(treePath, e.getPoint());
        }
    }

    protected void handlePopupMenuInvoked(TreePath path, Point pt) {
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getOWLModelManager().removeListener(this.listener);
        this.getOWLModelManager().getOWLEntityRenderer().removeListener(this.rendererListener);
    }
}

