/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.usage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.usage.UsageFilter;
import org.protege.editor.owl.ui.usage.UsagePreferences;
import org.protege.editor.owl.ui.usage.UsageTree;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLProperty;

public class UsagePanel
extends JPanel {
    private static final long serialVersionUID = 6031827085477038591L;
    private UsageTree tree;
    private JCheckBox showAllCheckbox;
    private JCheckBox showDisjointsCheckbox;
    private JCheckBox showDifferentCheckbox;
    private JCheckBox showNamedSubSuperclassesCheckbox;
    private OWLEntity currentSelection;

    public UsagePanel(OWLEditorKit owlEditorKit) {
        this.setLayout(new BorderLayout());
        this.tree = new UsageTree(owlEditorKit);
        this.showAllCheckbox = new JCheckBox("this", !UsagePreferences.getInstance().isFilterActive(UsageFilter.filterSelf));
        this.showAllCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                UsagePreferences.getInstance().setFilterActive(UsageFilter.filterSelf, !UsagePanel.this.showAllCheckbox.isSelected());
                UsagePanel.this.setOWLEntity(UsagePanel.this.currentSelection);
            }
        });
        this.showDisjointsCheckbox = new JCheckBox("disjoints", !UsagePreferences.getInstance().isFilterActive(UsageFilter.filterDisjoints));
        this.showDisjointsCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                UsagePreferences.getInstance().setFilterActive(UsageFilter.filterDisjoints, !UsagePanel.this.showDisjointsCheckbox.isSelected());
                UsagePanel.this.setOWLEntity(UsagePanel.this.currentSelection);
            }
        });
        this.showDifferentCheckbox = new JCheckBox("different", !UsagePreferences.getInstance().isFilterActive(UsageFilter.filterDifferent));
        this.showDifferentCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                UsagePreferences.getInstance().setFilterActive(UsageFilter.filterDifferent, !UsagePanel.this.showDifferentCheckbox.isSelected());
                UsagePanel.this.setOWLEntity(UsagePanel.this.currentSelection);
            }
        });
        this.showNamedSubSuperclassesCheckbox = new JCheckBox("named sub/superclasses", !UsagePreferences.getInstance().isFilterActive(UsageFilter.filterNamedSubsSupers));
        this.showNamedSubSuperclassesCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                UsagePreferences.getInstance().setFilterActive(UsageFilter.filterNamedSubsSupers, !UsagePanel.this.showNamedSubSuperclassesCheckbox.isSelected());
                UsagePanel.this.setOWLEntity(UsagePanel.this.currentSelection);
            }
        });
        Box box = new Box(2);
        box.add(new JLabel("Show: "));
        box.add(this.showAllCheckbox);
        box.add(this.showDisjointsCheckbox);
        box.add(this.showDifferentCheckbox);
        box.add(this.showNamedSubSuperclassesCheckbox);
        this.add((Component)box, "North");
        this.add((Component)new JScrollPane(this.tree), "Center");
    }

    public void setOWLEntity(OWLEntity entity) {
        this.currentSelection = entity;
        this.showNamedSubSuperclassesCheckbox.setVisible(entity != null && entity instanceof OWLClass);
        this.showDisjointsCheckbox.setVisible(entity != null && (entity instanceof OWLProperty || entity instanceof OWLClass));
        this.showDifferentCheckbox.setVisible(entity != null && entity instanceof OWLIndividual);
        this.tree.setOWLEntity(entity);
    }
}

