/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.OWLClassDescriptionEditor;
import org.protege.editor.owl.ui.editor.OWLClassExpressionEditor;
import org.protege.editor.owl.ui.editor.OWLClassExpressionEditorPlugin;
import org.protege.editor.owl.ui.editor.OWLClassExpressionEditorPluginLoader;
import org.protege.editor.owl.ui.selector.OWLClassSelectorPanel;
import org.protege.editor.owl.ui.selector.OWLDataPropertySelectorPanel;
import org.protege.editor.owl.ui.selector.OWLIndividualSelectorPanel;
import org.protege.editor.owl.ui.selector.OWLObjectPropertySelectorPanel;
import org.protege.editor.owl.ui.util.OWLComponentFactory;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.slf4j.LoggerFactory;

public class OWLComponentFactoryImpl
implements OWLComponentFactory {
    private OWLEditorKit eKit;
    private OWLClassSelectorPanel classSelectorPanel;
    private OWLObjectPropertySelectorPanel objectPropertySelectorPanel;
    private OWLDataPropertySelectorPanel dataPropertySelectorPanel;
    private OWLIndividualSelectorPanel individualSelectorPanel;
    private List<OWLClassExpressionEditorPlugin> descriptionEditorPlugins;

    public OWLComponentFactoryImpl(OWLEditorKit eKit) {
        this.eKit = eKit;
    }

    @Override
    public OWLClassDescriptionEditor getOWLClassDescriptionEditor(OWLClassExpression expr) {
        return this.getOWLClassDescriptionEditor(expr, null);
    }

    @Override
    public OWLClassDescriptionEditor getOWLClassDescriptionEditor(OWLClassExpression expr, AxiomType type) {
        OWLClassDescriptionEditor editor = new OWLClassDescriptionEditor(this.eKit, expr);
        TreeMap<String, OWLClassExpressionEditor> editorMap = new TreeMap<String, OWLClassExpressionEditor>();
        for (OWLClassExpressionEditorPlugin plugin : this.getDescriptionEditorPlugins()) {
            try {
                if (type != null && !plugin.isSuitableFor(type)) continue;
                OWLClassExpressionEditor editorPanel = (OWLClassExpressionEditor)plugin.newInstance();
                if (type != null) {
                    editorPanel.setAxiomType(type);
                }
                editorPanel.initialise();
                editorMap.put(plugin.getIndex(), editorPanel);
            }
            catch (Throwable e) {
                LoggerFactory.getLogger(OWLComponentFactoryImpl.class).error("An error occurred whilst initializing a class description editor: {}", e);
            }
        }
        for (String key : editorMap.keySet()) {
            editor.addPanel((OWLClassExpressionEditor)editorMap.get(key));
        }
        editor.selectPreferredEditor();
        return editor;
    }

    @Override
    public OWLClassSelectorPanel getOWLClassSelectorPanel() {
        if (this.classSelectorPanel == null) {
            this.classSelectorPanel = new OWLClassSelectorPanel(this.eKit);
        }
        return this.classSelectorPanel;
    }

    @Override
    public OWLObjectPropertySelectorPanel getOWLObjectPropertySelectorPanel() {
        if (this.objectPropertySelectorPanel == null) {
            this.objectPropertySelectorPanel = new OWLObjectPropertySelectorPanel(this.eKit);
        }
        return this.objectPropertySelectorPanel;
    }

    @Override
    public OWLDataPropertySelectorPanel getOWLDataPropertySelectorPanel() {
        if (this.dataPropertySelectorPanel == null) {
            this.dataPropertySelectorPanel = new OWLDataPropertySelectorPanel(this.eKit);
        }
        return this.dataPropertySelectorPanel;
    }

    @Override
    public OWLIndividualSelectorPanel getOWLIndividualSelectorPanel() {
        if (this.individualSelectorPanel == null) {
            this.individualSelectorPanel = new OWLIndividualSelectorPanel(this.eKit);
        }
        return this.individualSelectorPanel;
    }

    @Override
    public void dispose() {
        if (this.classSelectorPanel != null) {
            this.classSelectorPanel.dispose();
        }
        if (this.objectPropertySelectorPanel != null) {
            this.objectPropertySelectorPanel.dispose();
        }
        if (this.dataPropertySelectorPanel != null) {
            this.dataPropertySelectorPanel.dispose();
        }
        if (this.individualSelectorPanel != null) {
            this.individualSelectorPanel.dispose();
        }
    }

    private List<OWLClassExpressionEditorPlugin> getDescriptionEditorPlugins() {
        if (this.descriptionEditorPlugins == null) {
            OWLClassExpressionEditorPluginLoader loader = new OWLClassExpressionEditorPluginLoader(this.eKit);
            this.descriptionEditorPlugins = new ArrayList<OWLClassExpressionEditorPlugin>(loader.getPlugins());
            Comparator<OWLClassExpressionEditorPlugin> clsDescrPluginComparator = new Comparator<OWLClassExpressionEditorPlugin>(){

                @Override
                public int compare(OWLClassExpressionEditorPlugin p1, OWLClassExpressionEditorPlugin p2) {
                    return p1.getIndex().compareTo(p2.getIndex());
                }
            };
            Collections.sort(this.descriptionEditorPlugins, clsDescrPluginComparator);
        }
        return this.descriptionEditorPlugins;
    }
}

