/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view;

import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.List;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.ui.view.AbstractOWLViewComponent;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;

public abstract class AbstractActiveOntologyViewComponent
extends AbstractOWLViewComponent {
    private static final long serialVersionUID = 4137940424821355598L;
    private OWLModelManagerListener owlModelManagerListener;
    private OWLOntologyChangeListener owlOntologyChangeListener;
    private HierarchyListener hierarchyListener;
    private boolean updateView;

    @Override
    protected final void initialiseOWLView() throws Exception {
        this.owlModelManagerListener = new OWLModelManagerListener(){

            @Override
            public void handleChange(OWLModelManagerChangeEvent event) {
                if (event.isType(EventType.ACTIVE_ONTOLOGY_CHANGED)) {
                    AbstractActiveOntologyViewComponent.this.updateView = true;
                    AbstractActiveOntologyViewComponent.this.markForUpdate();
                }
            }
        };
        this.getOWLModelManager().addListener(this.owlModelManagerListener);
        this.owlOntologyChangeListener = new OWLOntologyChangeListener(){

            public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
                for (OWLOntologyChange oWLOntologyChange : changes) {
                    if (!oWLOntologyChange.getOntology().equals(AbstractActiveOntologyViewComponent.this.getOWLModelManager().getActiveOntology())) continue;
                    AbstractActiveOntologyViewComponent.this.updateView = true;
                    AbstractActiveOntologyViewComponent.this.markForUpdate();
                    break;
                }
            }
        };
        this.getOWLModelManager().addOntologyChangeListener(this.owlOntologyChangeListener);
        this.hierarchyListener = new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                AbstractActiveOntologyViewComponent.this.markForUpdate();
            }
        };
        this.addHierarchyListener(this.hierarchyListener);
        this.initialiseOntologyView();
    }

    protected abstract void initialiseOntologyView() throws Exception;

    @Override
    protected final void disposeOWLView() {
        this.getOWLModelManager().removeListener(this.owlModelManagerListener);
        this.getOWLModelManager().removeOntologyChangeListener(this.owlOntologyChangeListener);
        this.disposeOntologyView();
    }

    protected abstract void disposeOntologyView();

    private void markForUpdate() {
        if (this.isShowing() && this.updateView) {
            try {
                if (this.isSynchronizing()) {
                    this.updateView(this.getOWLModelManager().getActiveOntology());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.updateView = false;
        } else {
            this.updateView = true;
        }
    }

    protected abstract void updateView(OWLOntology var1) throws Exception;
}

