/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.protege.editor.owl.model.entity.OWLEntityCreationSet;
import org.protege.editor.owl.ui.action.AbstractDeleteEntityAction;
import org.protege.editor.owl.ui.action.AbstractOWLTreeAction;
import org.protege.editor.owl.ui.view.AbstractOWLEntityHierarchyViewComponent;
import org.protege.editor.owl.ui.view.CreateNewChildTarget;
import org.protege.editor.owl.ui.view.CreateNewSiblingTarget;
import org.protege.editor.owl.ui.view.Deleteable;
import org.protege.editor.owl.ui.view.Findable;
import org.protege.editor.owl.ui.view.OWLPropertyTreeDropHandler;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLProperty;
import org.semanticweb.owlapi.model.OWLSubPropertyAxiom;
import org.semanticweb.owlapi.util.OWLEntitySetProvider;

public abstract class AbstractOWLPropertyHierarchyViewComponent<O extends OWLProperty>
extends AbstractOWLEntityHierarchyViewComponent<O>
implements Findable<O>,
Deleteable,
CreateNewChildTarget,
CreateNewSiblingTarget {
    private static final long serialVersionUID = 9069497093520748684L;

    protected abstract OWLSubPropertyAxiom getSubPropertyAxiom(O var1, O var2);

    protected abstract boolean canAcceptDrop(Object var1, Object var2);

    protected abstract OWLEntityCreationSet<O> createProperty();

    protected abstract Icon getSubIcon();

    protected abstract Icon getSibIcon();

    protected abstract Icon getDeleteIcon();

    @Override
    protected void performExtraInitialisation() throws Exception {
        this.addAction(new AbstractOWLTreeAction<O>("Add sub property", this.getSubIcon(), this.getTree().getSelectionModel()){
            private static final long serialVersionUID = -1108739210585116570L;

            public void actionPerformed(ActionEvent event) {
                AbstractOWLPropertyHierarchyViewComponent.this.createNewChild();
            }

            @Override
            protected boolean canPerform(O prop) {
                return AbstractOWLPropertyHierarchyViewComponent.this.canCreateNewChild();
            }
        }, "A", "A");
        this.addAction(new AbstractOWLTreeAction<O>("Add sibling property", this.getSibIcon(), this.getTree().getSelectionModel()){
            private static final long serialVersionUID = 29239289622664679L;

            public void actionPerformed(ActionEvent event) {
                AbstractOWLPropertyHierarchyViewComponent.this.createNewSibling();
            }

            @Override
            protected boolean canPerform(O cls) {
                return AbstractOWLPropertyHierarchyViewComponent.this.canCreateNewSibling();
            }
        }, "A", "B");
        this.addAction(new AbstractDeleteEntityAction<O>("Delete selected properties", this.getDeleteIcon(), this.getOWLEditorKit(), this.getHierarchyProvider(), new OWLEntitySetProvider<O>(){

            public Set<O> getEntities() {
                return AbstractOWLPropertyHierarchyViewComponent.this.getSelectedEntities();
            }
        }){
            private static final long serialVersionUID = -2505868423392875972L;

            @Override
            protected String getPluralDescription() {
                return "properties";
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!AbstractOWLPropertyHierarchyViewComponent.this.getTopProperty().equals(AbstractOWLPropertyHierarchyViewComponent.this.getSelectedEntity())) {
                    super.actionPerformed(e);
                }
            }
        }, "B", "A");
        this.getTree().setDragAndDropHandler(new OWLPropertyTreeDropHandler<O>(this.getOWLModelManager()){

            @Override
            protected OWLAxiom getAxiom(OWLDataFactory df, O child, O parent) {
                return AbstractOWLPropertyHierarchyViewComponent.this.getSubPropertyAxiom(child, parent);
            }

            @Override
            public boolean canDrop(Object child, Object parent) {
                return AbstractOWLPropertyHierarchyViewComponent.this.canAcceptDrop(child, parent);
            }
        });
    }

    protected final OWLEntity updateView() {
        OWLProperty selProp = null;
        if (this.isOWLDataPropertyView()) {
            selProp = (OWLProperty)this.updateView(this.getOWLWorkspace().getOWLSelectionModel().getLastSelectedDataProperty());
        } else if (this.isOWLObjectPropertyView()) {
            selProp = (OWLProperty)this.updateView(this.getOWLWorkspace().getOWLSelectionModel().getLastSelectedObjectProperty());
        }
        if (selProp != null) {
            this.updateRegisteredActions();
        } else {
            this.disableRegisteredActions();
        }
        return selProp;
    }

    @Override
    public List<O> find(String match) {
        if (this.isOWLDataPropertyView()) {
            return new ArrayList<OWLDataProperty>(this.getOWLModelManager().getOWLEntityFinder().getMatchingOWLDataProperties(match));
        }
        if (this.isOWLObjectPropertyView()) {
            return new ArrayList<OWLObjectProperty>(this.getOWLModelManager().getOWLEntityFinder().getMatchingOWLObjectProperties(match));
        }
        return Collections.emptyList();
    }

    @Override
    public boolean canCreateNewChild() {
        return this.getSelectedEntity() != null;
    }

    @Override
    public void createNewChild() {
        OWLProperty selectedProperty = (OWLProperty)this.getSelectedEntity();
        if (selectedProperty == null) {
            return;
        }
        OWLEntityCreationSet<O> set = this.createProperty();
        if (set != null) {
            ArrayList<Object> changes = new ArrayList<Object>();
            changes.addAll(set.getOntologyChanges());
            if (this.shouldAddAsParentOfNewlyCreatedProperty(selectedProperty)) {
                OWLSubPropertyAxiom ax = this.getSubPropertyAxiom((OWLProperty)set.getOWLEntity(), selectedProperty);
                changes.add(new AddAxiom(this.getOWLModelManager().getActiveOntology(), (OWLAxiom)ax));
            }
            this.getOWLModelManager().applyChanges(changes);
            this.getTree().setSelectedOWLObject(set.getOWLEntity());
        }
    }

    @Override
    public boolean canCreateNewSibling() {
        return this.getSelectedEntity() != null && !((OWLProperty)this.getSelectedEntity()).equals(this.getTopProperty());
    }

    @Override
    public void createNewSibling() {
        OWLProperty property = (OWLProperty)this.getTree().getSelectedOWLObject();
        if (property == null) {
            return;
        }
        OWLEntityCreationSet<O> creationSet = this.createProperty();
        if (creationSet != null) {
            ArrayList<Object> changes = new ArrayList<Object>();
            changes.addAll(creationSet.getOntologyChanges());
            OWLOntology ont = this.getOWLModelManager().getActiveOntology();
            for (OWLProperty parentProperty : this.getHierarchyProvider().getParents(property)) {
                if (!this.shouldAddAsParentOfNewlyCreatedProperty(parentProperty)) continue;
                OWLSubPropertyAxiom ax = this.getSubPropertyAxiom((OWLProperty)creationSet.getOWLEntity(), parentProperty);
                changes.add(new AddAxiom(ont, (OWLAxiom)ax));
            }
            this.getOWLModelManager().applyChanges(changes);
            this.getTree().setSelectedOWLObject(creationSet.getOWLEntity());
        }
    }

    protected boolean shouldAddAsParentOfNewlyCreatedProperty(O parent) {
        return !this.getHierarchyProvider().getRoots().contains(parent);
    }

    private O getTopProperty() {
        return (O)((OWLProperty)this.getHierarchyProvider().getRoots().iterator().next());
    }
}

