/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view;

import java.awt.Component;
import java.awt.Toolkit;
import java.util.List;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.protege.editor.core.ui.view.ViewComponent;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.OWLWorkspace;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObject;

public abstract class AbstractOWLViewComponent
extends ViewComponent {
    private static final long serialVersionUID = -3089829405015180530L;

    public OWLModelManager getOWLModelManager() {
        return this.getOWLWorkspace().getOWLEditorKit().getModelManager();
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.getOWLWorkspace().getOWLEditorKit();
    }

    protected abstract void initialiseOWLView() throws Exception;

    public final void initialise() throws Exception {
        this.initialiseOWLView();
        this.prepareCopyable();
        this.preparePasteable();
        this.prepareCuttable();
    }

    private void prepareCopyable() {
        AbstractOWLViewComponent.removeFromInputMap(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), (JComponent)((Object)this));
    }

    private void preparePasteable() {
        AbstractOWLViewComponent.removeFromInputMap(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), (JComponent)((Object)this));
    }

    private void prepareCuttable() {
        AbstractOWLViewComponent.removeFromInputMap(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), (JComponent)((Object)this));
    }

    private static void removeFromInputMap(KeyStroke ks, JComponent c) {
        AbstractOWLViewComponent.removeKeyBinding(c.getInputMap(1), ks);
        AbstractOWLViewComponent.removeKeyBinding(c.getInputMap(2), ks);
        AbstractOWLViewComponent.removeKeyBinding(c.getInputMap(0), ks);
        for (Component child : c.getComponents()) {
            if (!(child instanceof JComponent)) continue;
            AbstractOWLViewComponent.removeFromInputMap(ks, (JComponent)child);
        }
    }

    private static void removeKeyBinding(InputMap im, KeyStroke ks) {
        if (im.getParent() != null) {
            im.getParent().remove(ks);
        }
    }

    protected OWLDataFactory getOWLDataFactory() {
        return this.getOWLModelManager().getOWLDataFactory();
    }

    public final void dispose() {
        this.disposeOWLView();
    }

    protected abstract void disposeOWLView();

    public OWLWorkspace getOWLWorkspace() {
        return (OWLWorkspace)this.getWorkspace();
    }

    protected OWLObject getObjectToCopy() {
        return null;
    }

    protected void handlePaste(List<OWLObject> objects) {
    }
}

