/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view.cls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JScrollPane;
import org.protege.editor.owl.ui.frame.cls.OWLClassDescriptionFrame;
import org.protege.editor.owl.ui.frame.cls.OWLSubClassAxiomFrameSectionRow;
import org.protege.editor.owl.ui.framelist.CreateClosureAxiomAction;
import org.protege.editor.owl.ui.framelist.CreateNewEquivalentClassAction;
import org.protege.editor.owl.ui.framelist.OWLFrameList;
import org.protege.editor.owl.ui.framelist.OWLFrameListPopupMenuAction;
import org.protege.editor.owl.ui.view.cls.AbstractOWLClassViewComponent;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.CollectionFactory;

public class OWLClassDescriptionViewComponent
extends AbstractOWLClassViewComponent {
    private static final long serialVersionUID = -7899828024396593253L;
    private OWLFrameList<OWLClass> list;

    @Override
    public void initialiseClassView() throws Exception {
        this.list = new OWLFrameList<OWLClass>(this.getOWLEditorKit(), new OWLClassDescriptionFrame(this.getOWLEditorKit()));
        this.setLayout(new BorderLayout());
        JScrollPane sp = new JScrollPane((Component)((Object)this.list));
        sp.setHorizontalScrollBarPolicy(31);
        this.add(sp);
        this.list.addToPopupMenu(new ConvertSelectionToEquivalentClassAction());
        this.list.addToPopupMenu(new CreateNewEquivalentClassAction());
        this.list.addToPopupMenu(new CreateClosureAxiomAction());
    }

    @Override
    protected OWLClass updateView(OWLClass selectedClass) {
        this.list.setRootObject(selectedClass);
        return selectedClass;
    }

    @Override
    public void disposeView() {
        this.list.dispose();
    }

    private void convertSelectedRowsToDefinedClass() {
        Object[] selVals = this.list.getSelectedValues();
        if (selVals.length > 0) {
            HashSet<OWLClassExpression> descriptions = new HashSet<OWLClassExpression>();
            ArrayList<Object> changes = new ArrayList<Object>();
            for (Object selVal : selVals) {
                if (!(selVal instanceof OWLSubClassAxiomFrameSectionRow)) continue;
                OWLSubClassAxiomFrameSectionRow row = (OWLSubClassAxiomFrameSectionRow)selVal;
                changes.add(new RemoveAxiom(row.getOntology(), row.getAxiom()));
                descriptions.add(((OWLSubClassOfAxiom)row.getAxiom()).getSuperClass());
            }
            Object equivalentClass = descriptions.size() == 1 ? (OWLClassExpression)descriptions.iterator().next() : this.getOWLDataFactory().getOWLObjectIntersectionOf(descriptions);
            Set axiomOperands = CollectionFactory.createSet((Object[])new OWLClassExpression[]{(OWLClassExpression)this.list.getRootObject(), equivalentClass});
            changes.add(new AddAxiom(this.getOWLModelManager().getActiveOntology(), (OWLAxiom)this.getOWLDataFactory().getOWLEquivalentClassesAxiom(axiomOperands)));
            this.getOWLModelManager().applyChanges(changes);
        }
    }

    private class ConvertSelectionToEquivalentClassAction
    extends OWLFrameListPopupMenuAction<OWLClass> {
        private static final long serialVersionUID = 8523837123917366996L;

        private ConvertSelectionToEquivalentClassAction() {
        }

        @Override
        protected void initialise() throws Exception {
        }

        @Override
        protected void dispose() throws Exception {
        }

        @Override
        protected String getName() {
            return "Convert selected rows to defined class";
        }

        @Override
        protected void updateState() {
            if (OWLClassDescriptionViewComponent.this.list.getSelectedValue() == null) {
                this.setEnabled(false);
                return;
            }
            for (Object selVal : OWLClassDescriptionViewComponent.this.list.getSelectedValues()) {
                if (selVal instanceof OWLSubClassAxiomFrameSectionRow) continue;
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OWLClassDescriptionViewComponent.this.convertSelectedRowsToDefinedClass();
        }
    }
}

