/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view.dataproperty;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import org.protege.editor.owl.model.axiom.FreshAxiomLocationPreferences;
import org.protege.editor.owl.model.axiom.FreshAxiomLocationStrategy;
import org.protege.editor.owl.model.axiom.FreshAxiomLocationStrategyFactory;
import org.protege.editor.owl.ui.view.dataproperty.AbstractOWLDataPropertyViewComponent;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.FilteringOWLOntologyChangeListener;

public class OWLDataPropertyCharacteristicsViewComponent
extends AbstractOWLDataPropertyViewComponent {
    private static final long serialVersionUID = 161692781388151940L;
    private JCheckBox checkBox;
    private OWLDataProperty prop;
    private OWLOntologyChangeListener listener;

    @Override
    protected OWLDataProperty updateView(OWLDataProperty property) {
        this.prop = property;
        this.checkBox.setEnabled(property != null);
        this.checkBox.setSelected(false);
        if (property == null) {
            return null;
        }
        for (OWLOntology ont : this.getOWLModelManager().getActiveOntologies()) {
            if (ont.getFunctionalDataPropertyAxioms((OWLDataPropertyExpression)this.prop).isEmpty()) continue;
            this.checkBox.setSelected(true);
            break;
        }
        return property;
    }

    @Override
    public void disposeView() {
        super.disposeView();
        this.getOWLModelManager().removeOntologyChangeListener(this.listener);
    }

    @Override
    public void initialiseView() throws Exception {
        this.setLayout(new BorderLayout());
        this.checkBox = new JCheckBox("Functional");
        Box box = new Box(3);
        box.setOpaque(false);
        box.add(this.checkBox);
        this.add(new JScrollPane(box));
        this.listener = new FilteringOWLOntologyChangeListener(){

            public void visit(OWLFunctionalDataPropertyAxiom axiom) {
                OWLDataPropertyCharacteristicsViewComponent.this.updateView(OWLDataPropertyCharacteristicsViewComponent.this.prop);
            }
        };
        this.getOWLModelManager().addOntologyChangeListener(this.listener);
        this.checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OWLDataPropertyCharacteristicsViewComponent.this.updateOntology();
            }
        });
    }

    private void updateOntology() {
        if (this.prop == null) {
            return;
        }
        OWLDataFactory df = this.getOWLModelManager().getOWLDataFactory();
        OWLFunctionalDataPropertyAxiom ax = df.getOWLFunctionalDataPropertyAxiom((OWLDataPropertyExpression)this.prop);
        if (this.checkBox.isSelected()) {
            FreshAxiomLocationPreferences preferences = FreshAxiomLocationPreferences.getPreferences();
            FreshAxiomLocationStrategyFactory strategyFactory = preferences.getFreshAxiomLocation().getStrategyFactory();
            FreshAxiomLocationStrategy strategy = strategyFactory.getStrategy(this.getOWLEditorKit());
            OWLOntology ont = strategy.getFreshAxiomLocation((OWLAxiom)ax, this.getOWLModelManager());
            this.getOWLModelManager().applyChange((OWLOntologyChange)new AddAxiom(ont, (OWLAxiom)ax));
        } else {
            ArrayList<RemoveAxiom> changes = new ArrayList<RemoveAxiom>();
            for (OWLOntology ont : this.getOWLModelManager().getActiveOntologies()) {
                changes.add(new RemoveAxiom(ont, (OWLAxiom)ax));
            }
            this.getOWLModelManager().applyChanges(changes);
        }
    }
}

