/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view.datatype;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.core.ui.view.DisposableAction;
import org.protege.editor.owl.model.entity.OWLEntityCreationSet;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.util.OWLDataTypeUtils;
import org.protege.editor.owl.model.util.OWLEntityDeleter;
import org.protege.editor.owl.ui.OWLIcons;
import org.protege.editor.owl.ui.list.OWLObjectList;
import org.protege.editor.owl.ui.view.ChangeListenerMediator;
import org.protege.editor.owl.ui.view.Findable;
import org.protege.editor.owl.ui.view.OWLSelectionViewAction;
import org.protege.editor.owl.ui.view.datatype.AbstractOWLDataTypeViewComponent;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class OWLDataTypeViewComponent
extends AbstractOWLDataTypeViewComponent
implements Findable<OWLDatatype> {
    private static final long serialVersionUID = 3202742013883811816L;
    private OWLObjectList<OWLDatatype> list;
    private ChangeListenerMediator changeListenerMediator;
    private ListSelectionListener selListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (OWLDataTypeViewComponent.this.list.getSelectedValue() != null) {
                    OWLDataTypeViewComponent.this.setGlobalSelection((OWLEntity)((OWLDatatype)OWLDataTypeViewComponent.this.list.getSelectedValue()));
                }
                OWLDataTypeViewComponent.this.changeListenerMediator.fireStateChanged(OWLDataTypeViewComponent.this);
            }
        }
    };
    private OWLOntologyChangeListener ontChangeListener = new OWLOntologyChangeListener(){

        public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
            OWLDataTypeViewComponent.this.handleChanges(changes);
        }
    };
    private OWLModelManagerListener modelManagerListener = new OWLModelManagerListener(){

        @Override
        public void handleChange(OWLModelManagerChangeEvent event) {
            if (event.getType() == EventType.ACTIVE_ONTOLOGY_CHANGED) {
                OWLDataTypeViewComponent.this.reload();
            }
        }
    };

    @Override
    public void initialiseView() throws Exception {
        this.setLayout(new BorderLayout());
        this.changeListenerMediator = new ChangeListenerMediator();
        this.list = new OWLObjectList(this.getOWLEditorKit());
        this.list.addListSelectionListener(this.selListener);
        this.reload();
        this.setupActions();
        this.getOWLModelManager().addOntologyChangeListener(this.ontChangeListener);
        this.getOWLModelManager().addListener(this.modelManagerListener);
        this.add(ComponentFactory.createScrollPane(this.list));
    }

    private void setupActions() {
        DisposableAction addDatatypeAction = new DisposableAction("Add datatype", OWLIcons.getIcon("datarange.add.png")){
            private static final long serialVersionUID = 7152977701137488187L;

            public void actionPerformed(ActionEvent event) {
                OWLDataTypeViewComponent.this.createNewDatatype();
            }

            public void dispose() {
            }
        };
        OWLSelectionViewAction deleteDatatypeAction = new OWLSelectionViewAction("Delete datatype", OWLIcons.getIcon("datarange.remove.png")){
            private static final long serialVersionUID = 5359788681251086828L;

            public void actionPerformed(ActionEvent event) {
                OWLDataTypeViewComponent.this.deleteDatatype();
            }

            @Override
            public void updateState() {
                this.setEnabled(OWLDataTypeViewComponent.this.list.getSelectedIndex() != -1);
            }

            public void dispose() {
            }
        };
        this.addAction(addDatatypeAction, "A", "A");
        this.addAction(deleteDatatypeAction, "B", "A");
    }

    private void deleteDatatype() {
        OWLEntityDeleter.deleteEntities(this.list.getSelectedOWLObjects(), this.getOWLModelManager());
    }

    private void createNewDatatype() {
        OWLEntityCreationSet<OWLDatatype> set = this.getOWLWorkspace().createOWLDatatype();
        if (set == null) {
            return;
        }
        this.getOWLModelManager().applyChanges(set.getOntologyChanges());
        OWLDatatype datatype = set.getOWLEntity();
        if (datatype != null) {
            this.list.setSelectedValue(datatype, true);
        }
    }

    private void handleChanges(List<? extends OWLOntologyChange> changes) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange()) continue;
            for (OWLEntity entity : oWLOntologyChange.getAxiom().getSignature()) {
                if (!entity.isOWLDatatype()) continue;
                this.reload();
                return;
            }
        }
    }

    @Override
    public void disposeView() {
        this.getOWLModelManager().removeOntologyChangeListener(this.ontChangeListener);
        this.getOWLModelManager().removeListener(this.modelManagerListener);
    }

    @Override
    protected OWLDatatype updateView(OWLDatatype dt) {
        if (dt != null) {
            this.list.setSelectedValue(dt, true);
        } else {
            this.list.clearSelection();
        }
        return dt;
    }

    private void reload() {
        OWLOntologyManager mngr = this.getOWLModelManager().getOWLOntologyManager();
        ArrayList<OWLDatatype> datatypeList = new ArrayList<OWLDatatype>(new OWLDataTypeUtils(mngr).getKnownDatatypes(this.getOWLModelManager().getActiveOntologies()));
        Collections.sort(datatypeList, this.getOWLModelManager().getOWLObjectComparator());
        this.list.setListData(datatypeList.toArray(new OWLDatatype[datatypeList.size()]));
        OWLDatatype sel = this.getOWLWorkspace().getOWLSelectionModel().getLastSelectedDatatype();
        if (datatypeList.contains(sel)) {
            this.list.setSelectedValue(sel, true);
        }
    }

    @Override
    public List<OWLDatatype> find(String match) {
        return new ArrayList<OWLDatatype>(this.getOWLModelManager().getOWLEntityFinder().getMatchingOWLDatatypes(match));
    }

    @Override
    public void show(OWLDatatype dt) {
        this.updateView(dt);
    }
}

