/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view.individual;

import java.util.List;
import org.protege.editor.owl.model.selection.OWLSelectionModelListener;
import org.protege.editor.owl.ui.framelist.OWLFrameList;
import org.protege.editor.owl.ui.view.individual.OWLIndividualListViewComponent;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class OWLInferredMemberListViewComponent
extends OWLIndividualListViewComponent {
    private static final long serialVersionUID = 8626425915826524799L;
    private OWLSelectionModelListener refillOnClassSelectionListener = new OWLSelectionModelListener(){

        @Override
        public void selectionChanged() throws Exception {
            if (OWLInferredMemberListViewComponent.this.getOWLWorkspace().getOWLSelectionModel().getSelectedObject() instanceof OWLClass) {
                OWLInferredMemberListViewComponent.this.refill();
            }
        }
    };

    @Override
    public void initialiseIndividualsView() throws Exception {
        super.initialiseIndividualsView();
        this.getOWLWorkspace().getOWLSelectionModel().addListener(this.refillOnClassSelectionListener);
        this.setIndividualListColor(OWLFrameList.INFERRED_BG_COLOR);
    }

    @Override
    protected void setupActions() {
    }

    @Override
    protected void refill() {
        OWLReasoner reasoner;
        NodeSet individuals;
        this.individualsInList.clear();
        OWLClass cls = this.getOWLWorkspace().getOWLSelectionModel().getLastSelectedClass();
        if (cls != null && (individuals = (reasoner = this.getOWLModelManager().getReasoner()).getInstances((OWLClassExpression)cls, true)) != null) {
            for (OWLIndividual ind : individuals.getFlattened()) {
                if (ind.isAnonymous()) continue;
                this.individualsInList.add(ind.asOWLNamedIndividual());
            }
        }
        this.reset();
    }

    @Override
    protected void processChanges(List<? extends OWLOntologyChange> changes) {
        OWLReasoner reasoner = this.getOWLModelManager().getReasoner();
        if (reasoner.getPendingChanges().isEmpty()) {
            this.refill();
        }
    }

    @Override
    public void disposeView() {
        this.getOWLWorkspace().getOWLSelectionModel().removeListener(this.refillOnClassSelectionListener);
        super.disposeView();
    }

    @Override
    protected void reset() {
        super.reset();
        this.setIndividualListColor(OWLFrameList.INFERRED_BG_COLOR);
    }
}

