/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view.objectproperty;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import org.protege.editor.owl.model.axiom.FreshAxiomLocationPreferences;
import org.protege.editor.owl.model.axiom.FreshAxiomLocationStrategy;
import org.protege.editor.owl.model.axiom.FreshAxiomLocationStrategyFactory;
import org.protege.editor.owl.ui.view.objectproperty.AbstractOWLObjectPropertyViewComponent;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.FilteringOWLOntologyChangeListener;

public class OWLObjectPropertyCharacteristicsViewComponent
extends AbstractOWLObjectPropertyViewComponent {
    private static final long serialVersionUID = -1299595056337566960L;
    private JCheckBox functionalCB;
    private JCheckBox inverseFunctionalCB;
    private JCheckBox transitiveCB;
    private JCheckBox symmetricCB;
    private JCheckBox aSymmetricCB;
    private JCheckBox reflexiveCB;
    private JCheckBox irreflexiveCB;
    private List<JCheckBox> checkBoxes;
    private OWLOntologyChangeListener listener;
    private OWLObjectProperty prop;

    @Override
    public void initialiseView() throws Exception {
        this.functionalCB = new JCheckBox("Functional");
        this.inverseFunctionalCB = new JCheckBox("Inverse functional");
        this.transitiveCB = new JCheckBox("Transitive");
        this.symmetricCB = new JCheckBox("Symmetric");
        this.aSymmetricCB = new JCheckBox("Asymmetric");
        this.reflexiveCB = new JCheckBox("Reflexive");
        this.irreflexiveCB = new JCheckBox("Irreflexive");
        this.checkBoxes = new ArrayList<JCheckBox>();
        this.checkBoxes.add(this.functionalCB);
        this.checkBoxes.add(this.inverseFunctionalCB);
        this.checkBoxes.add(this.transitiveCB);
        this.checkBoxes.add(this.symmetricCB);
        this.checkBoxes.add(this.aSymmetricCB);
        this.checkBoxes.add(this.reflexiveCB);
        this.checkBoxes.add(this.irreflexiveCB);
        this.setLayout(new BorderLayout());
        Box box = new Box(1);
        box.setOpaque(false);
        box.add(this.functionalCB);
        box.add(Box.createVerticalStrut(7));
        box.add(this.inverseFunctionalCB);
        box.add(Box.createVerticalStrut(7));
        box.add(this.transitiveCB);
        box.add(Box.createVerticalStrut(7));
        box.add(this.symmetricCB);
        box.add(Box.createVerticalStrut(7));
        box.add(this.aSymmetricCB);
        box.add(Box.createVerticalStrut(7));
        box.add(this.reflexiveCB);
        box.add(Box.createVerticalStrut(7));
        box.add(this.irreflexiveCB);
        this.add(new JScrollPane(box));
        this.setupSetters();
        this.listener = new FilteringOWLOntologyChangeListener(){

            public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
                OWLObjectPropertyCharacteristicsViewComponent.this.updateView(OWLObjectPropertyCharacteristicsViewComponent.this.prop);
            }

            public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
                OWLObjectPropertyCharacteristicsViewComponent.this.updateView(OWLObjectPropertyCharacteristicsViewComponent.this.prop);
            }

            public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
                OWLObjectPropertyCharacteristicsViewComponent.this.updateView(OWLObjectPropertyCharacteristicsViewComponent.this.prop);
            }

            public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
                OWLObjectPropertyCharacteristicsViewComponent.this.updateView(OWLObjectPropertyCharacteristicsViewComponent.this.prop);
            }

            public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
                OWLObjectPropertyCharacteristicsViewComponent.this.updateView(OWLObjectPropertyCharacteristicsViewComponent.this.prop);
            }

            public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
                OWLObjectPropertyCharacteristicsViewComponent.this.updateView(OWLObjectPropertyCharacteristicsViewComponent.this.prop);
            }

            public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
                OWLObjectPropertyCharacteristicsViewComponent.this.updateView(OWLObjectPropertyCharacteristicsViewComponent.this.prop);
            }
        };
        this.getOWLModelManager().addOntologyChangeListener(this.listener);
    }

    private void setupSetters() {
        this.addSetter(this.functionalCB, new PropertyCharacteristicSetter(){

            @Override
            public OWLAxiom getAxiom() {
                return OWLObjectPropertyCharacteristicsViewComponent.this.getOWLDataFactory().getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)OWLObjectPropertyCharacteristicsViewComponent.this.getProperty());
            }
        });
        this.addSetter(this.inverseFunctionalCB, new PropertyCharacteristicSetter(){

            @Override
            public OWLAxiom getAxiom() {
                return OWLObjectPropertyCharacteristicsViewComponent.this.getOWLDataFactory().getOWLInverseFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)OWLObjectPropertyCharacteristicsViewComponent.this.getProperty());
            }
        });
        this.addSetter(this.transitiveCB, new PropertyCharacteristicSetter(){

            @Override
            public OWLAxiom getAxiom() {
                return OWLObjectPropertyCharacteristicsViewComponent.this.getOWLDataFactory().getOWLTransitiveObjectPropertyAxiom((OWLObjectPropertyExpression)OWLObjectPropertyCharacteristicsViewComponent.this.getProperty());
            }
        });
        this.addSetter(this.symmetricCB, new PropertyCharacteristicSetter(){

            @Override
            public OWLAxiom getAxiom() {
                return OWLObjectPropertyCharacteristicsViewComponent.this.getOWLDataFactory().getOWLSymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)OWLObjectPropertyCharacteristicsViewComponent.this.getProperty());
            }
        });
        this.addSetter(this.aSymmetricCB, new PropertyCharacteristicSetter(){

            @Override
            public OWLAxiom getAxiom() {
                return OWLObjectPropertyCharacteristicsViewComponent.this.getOWLDataFactory().getOWLAsymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)OWLObjectPropertyCharacteristicsViewComponent.this.getProperty());
            }
        });
        this.addSetter(this.reflexiveCB, new PropertyCharacteristicSetter(){

            @Override
            public OWLAxiom getAxiom() {
                return OWLObjectPropertyCharacteristicsViewComponent.this.getOWLDataFactory().getOWLReflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)OWLObjectPropertyCharacteristicsViewComponent.this.getProperty());
            }
        });
        this.addSetter(this.irreflexiveCB, new PropertyCharacteristicSetter(){

            @Override
            public OWLAxiom getAxiom() {
                return OWLObjectPropertyCharacteristicsViewComponent.this.getOWLDataFactory().getOWLIrreflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)OWLObjectPropertyCharacteristicsViewComponent.this.getProperty());
            }
        });
    }

    private void addSetter(final JCheckBox checkBox, final PropertyCharacteristicSetter setter) {
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OWLObjectPropertyCharacteristicsViewComponent.this.getProperty() == null) {
                    return;
                }
                if (checkBox.isSelected()) {
                    FreshAxiomLocationPreferences preferences = FreshAxiomLocationPreferences.getPreferences();
                    FreshAxiomLocationStrategyFactory strategyFactory = preferences.getFreshAxiomLocation().getStrategyFactory();
                    FreshAxiomLocationStrategy strategy = strategyFactory.getStrategy(OWLObjectPropertyCharacteristicsViewComponent.this.getOWLEditorKit());
                    OWLAxiom ax = setter.getAxiom();
                    OWLOntology ont = strategy.getFreshAxiomLocation(ax, OWLObjectPropertyCharacteristicsViewComponent.this.getOWLModelManager());
                    OWLObjectPropertyCharacteristicsViewComponent.this.getOWLModelManager().applyChange((OWLOntologyChange)new AddAxiom(ont, ax));
                } else {
                    ArrayList<RemoveAxiom> changes = new ArrayList<RemoveAxiom>();
                    OWLAxiom ax = setter.getAxiom();
                    for (OWLOntology ont : OWLObjectPropertyCharacteristicsViewComponent.this.getOWLModelManager().getActiveOntologies()) {
                        changes.add(new RemoveAxiom(ont, ax));
                    }
                    OWLObjectPropertyCharacteristicsViewComponent.this.getOWLModelManager().applyChanges(changes);
                }
            }
        });
    }

    private OWLObjectProperty getProperty() {
        return this.prop;
    }

    @Override
    public void disposeView() {
        this.getOWLModelManager().removeOntologyChangeListener(this.listener);
    }

    private void setCheckBoxesEnabled(boolean enable) {
        for (JCheckBox cb : this.checkBoxes) {
            cb.setEnabled(enable);
        }
    }

    private void clearAll() {
        for (JCheckBox cb : this.checkBoxes) {
            cb.setSelected(false);
        }
    }

    @Override
    protected OWLObjectProperty updateView(OWLObjectProperty property) {
        this.prop = property;
        this.clearAll();
        this.setCheckBoxesEnabled(property != null);
        if (property == null) {
            return null;
        }
        for (OWLOntology ont : this.getOWLModelManager().getActiveOntologies()) {
            if (!ont.getFunctionalObjectPropertyAxioms((OWLObjectPropertyExpression)property).isEmpty()) {
                this.functionalCB.setSelected(true);
                if (!this.getOWLModelManager().isMutable(ont)) {
                    this.functionalCB.setEnabled(false);
                }
            }
            if (!ont.getInverseFunctionalObjectPropertyAxioms((OWLObjectPropertyExpression)property).isEmpty()) {
                this.inverseFunctionalCB.setSelected(true);
                if (!this.getOWLModelManager().isMutable(ont)) {
                    this.inverseFunctionalCB.setEnabled(false);
                }
            }
            if (!ont.getTransitiveObjectPropertyAxioms((OWLObjectPropertyExpression)property).isEmpty()) {
                this.transitiveCB.setSelected(true);
                if (!this.getOWLModelManager().isMutable(ont)) {
                    this.transitiveCB.setEnabled(false);
                }
            }
            if (!ont.getSymmetricObjectPropertyAxioms((OWLObjectPropertyExpression)property).isEmpty()) {
                this.symmetricCB.setSelected(true);
                if (!this.getOWLModelManager().isMutable(ont)) {
                    this.symmetricCB.setEnabled(false);
                }
            }
            if (!ont.getAsymmetricObjectPropertyAxioms((OWLObjectPropertyExpression)property).isEmpty()) {
                this.aSymmetricCB.setSelected(true);
                if (!this.getOWLModelManager().isMutable(ont)) {
                    this.aSymmetricCB.setEnabled(false);
                }
            }
            if (!ont.getReflexiveObjectPropertyAxioms((OWLObjectPropertyExpression)property).isEmpty()) {
                this.reflexiveCB.setSelected(true);
                if (!this.getOWLModelManager().isMutable(ont)) {
                    this.reflexiveCB.setEnabled(false);
                }
            }
            if (ont.getIrreflexiveObjectPropertyAxioms((OWLObjectPropertyExpression)property).isEmpty()) continue;
            this.irreflexiveCB.setSelected(true);
            if (this.getOWLModelManager().isMutable(ont)) continue;
            this.irreflexiveCB.setEnabled(false);
        }
        return property;
    }

    private static interface PropertyCharacteristicSetter {
        public OWLAxiom getAxiom();
    }
}

